<?php $__env->startSection('title', $store->name); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <?php echo app('translator')->getFromJson('front.show'); ?> - <?php echo e($store->name); ?>

        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-xs-12">
                <div class="box">
                    
                    <!-- /.box-header -->
                    <div class="box-body">
                        <table id="dataList" class="table table-bordered table-striped dataTableTT">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th><?php echo app('translator')->getFromJson('front.product'); ?></th>
                                    <th><?php echo app('translator')->getFromJson('front.quantity'); ?></th>
                                    <th><?php echo app('translator')->getFromJson('front.unit'); ?></th>
                                    <?php if(auth()->user()->show_cost_price): ?>
                                        <th><?php echo app('translator')->getFromJson('front.cost'); ?></th>
                                        <th><?php echo app('translator')->getFromJson('front.total'); ?></th>
                                    <?php endif; ?>
                                    <th class="no-sort hide"></th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                    $total = 0;
                                ?>
                                <?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <?php
                                            $cost = $product->getCost();
                                            $qty = $product->qty - $product->sale_count;
                                            $subtotal = $cost * $qty;
                                            $total += $subtotal;
                                        ?>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e(optional($product->product)->name); ?></td>
                                        <td><?php echo e($qty); ?></td>
                                        <td><?php echo e(optional($product->unit)->name ?: 'محذوف'); ?></td>
                                        <?php if(auth()->user()->show_cost_price): ?>
                                            <td><?php echo e($cost); ?></td>
                                            <td><?php echo e($subtotal); ?></td>
                                        <?php endif; ?>
                                        <td class="hide"></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                            <?php if(auth()->user()->show_cost_price): ?>
                                <tfoot>
                                    <tr>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td><?php echo e($total); ?></td>
                                        <td class="hide"></td>
                                    </tr>
                                </tfoot>
                            <?php endif; ?>
                        </table>
                    </div>
                    <!-- /.box-body -->
                    <div class="text-center">
                        <?php echo e($list->render()); ?>

                    </div>
                </div>
                <!-- /.box -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>