<section class="content">
    <div class="box box-primary">
        <div class="box-body">
            <div class="row">
                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.name'); ?></label>
                        <div class="input-group">
                            <div class="input-group-addon">
                                <i class="fa fa-user"></i>
                            </div>

                            <input value="<?php echo e(request()->req); ?>" name="reqType" type="hidden"
                                class="form-control pull-right">
                            <input value="<?php echo e($person->name); ?>" required name="name" type="text"
                                class="form-control pull-right">
                        </div>
                        <!-- /.input group -->
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.telephone'); ?> 1</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                                <i class="fa fa-phone"></i>
                            </div>
                            <input value="<?php echo e(request('phone') ?: $person->mobile); ?>" name="mobile" type="text"
                                class="form-control pull-right">
                        </div>
                        <!-- /.input group -->
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.birthdate'); ?></label>
                        <div class="input-group">
                            <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </div>
                            <input value="<?php echo e($person->birthdate); ?>" name="birthdate" type="date"
                                class="form-control pull-right">
                        </div>
                        <!-- /.input group -->
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.eventdate'); ?></label>
                        <div class="input-group">
                            <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </div>
                            <input value="<?php echo e($person->eventdate); ?>" name="eventdate" type="date"
                                class="form-control pull-right">
                        </div>
                        <!-- /.input group -->
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.region'); ?></label>
                        <select name="region_id" class="form-control selectRegion" style="width: 100%;">
                            <option value=""><?php echo app('translator')->getFromJson('front.select region'); ?></option>
                            <?php $__currentLoopData = \App\Region::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e($region->id == $person->region_id ? 'selected' : ''); ?>

                                    value="<?php echo e($region->id); ?>"><?php echo e($region->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.address'); ?></label>
                        <input value="<?php echo e($person->address); ?>" name="address" type="text" class="form-control">
                    </div>
                </div>
            </div>
            <?php if(env('turbo_authentication_key')): ?>
                <div class="row">
                    <?php
                        $area = optional($person->area);
                    ?>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>المحافظة</label>
                            <select style="width: 100%" data-ajax--url="<?php echo e(route('governmentList')); ?>"
                                data-ajax--cache="true" data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>" id="governmentList"
                                name="government_id" class="form-control select2">
                                <?php if($area): ?>
                                    <option selected value="<?php echo e($area->government_id); ?>">
                                        <?php echo e(optional($area->government)->name); ?></option>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>منطقة الشحن</label>
                            <select style="width: 100%" data-url="<?php echo e(route('areasList')); ?>"
                                data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>" id="areasList" name="area_id" class="form-control">
                                <?php if($area): ?>
                                    <option selected value="<?php echo e($area->id); ?>">
                                        <?php echo e($area->name); ?></option>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
            <div class="row hide">
                <div class="col-md-4">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.pricetype'); ?></label>
                        <select name="priceType" class="form-control select2" style="width: 100%;">
                            <option <?php echo e($person->priceType == 'one' ? 'selected' : ''); ?> value="one">
                                <?php echo app('translator')->getFromJson('front.Sector'); ?>
                            </option>
                            <option <?php echo e($person->priceType == 'half' ? 'selected' : ''); ?> value="half">
                                <?php echo app('translator')->getFromJson('front.Half wholesale'); ?>
                            </option>
                            <option <?php echo e($person->priceType == 'multi' ? 'selected' : ''); ?> value="multi">
                                <?php echo app('translator')->getFromJson('front.Wholesale'); ?>
                            </option>
                            <option <?php echo e($person->priceType == 'gomla_gomla_price' ? 'selected' : ''); ?>

                                value="gomla_gomla_price"><?php echo app('translator')->getFromJson('front.Wholesale Wholesale'); ?></option>

                        </select>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.telephone'); ?> 2</label>
                        <div class="input-group">
                            <div class="input-group-addon">
                                <i class="fa fa-phone"></i>
                            </div>
                            <input value="<?php echo e($person->mobile2); ?>" name="mobile2" type="text" class="form-control">
                        </div>
                        <!-- /.input group -->
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="form-group">
                        <label>الرقم الضريبي</label>
                        <input value="<?php echo e($person->taxnumber); ?>" name="taxnumber" type="text" class="form-control">
                    </div>
                </div>

            </div>
            <div class="row hide">
                <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.The balance of the first duration'); ?></label>
                        <div class="input-group">
                            <div class="input-group-addon">
                                <i class="fa fa-money"></i>
                            </div>
                            <input value="<?php echo e(abs($person->balance)); ?>" name="start_balance" type="number"
                                class="form-control pull-right">
                        </div>
                        <!-- /.input group -->
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group checkbox">
                        <label style=" margin-top: 15px; ">
                            <input value="1" <?php echo e($person->balance < 0 || $type != 'client' ? 'checked' : ''); ?>

                                name="dept" type="radio" class="flat-red">
                            <?php echo app('translator')->getFromJson('front.creditor'); ?></label>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="form-group checkbox">
                        <label style=" margin-top: 15px; ">
                            <input <?php echo e($person->balance > 0 || $type == 'client' ? 'checked' : ''); ?> value="2"
                                name="dept" type="radio" class="flat-red">
                            <?php echo app('translator')->getFromJson('front.debit'); ?></label>
                    </div>
                </div>
            </div>
            <div class="row hide">
                <div style="padding-top: 10px;" class="col-md-12">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.isclientandsupplier'); ?></label>
                        <input id="is_client_supplier" name="is_client_supplier"
                            <?php if($person->is_client_supplier): ?> checked <?php endif; ?> type="checkbox" class="flat-red ">
                    </div>
                </div>
            </div>
            <div class="row hide">
                <div style="padding-top: 10px;" class="col-md-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.Remind me to review the account'); ?></label>
                        <input name="remember_review_balance" <?php if($person->remember_review_balance): ?> checked <?php endif; ?>
                            type="checkbox" class="flat-red ">
                    </div>
                </div>
                <div class="form-group col-md-6">

                    <div class="input-group date">
                        <div class="input-group-addon">
                            <i class="fa fa-calendar"></i>
                        </div>
                        <input readonly name="remember_date" type="text"
                            value="<?php echo e($person->remember_date ?: ''); ?>" id="datepicker" class="form-control">
                    </div>
                    <!-- /.input group -->
                </div>
            </div>
            <?php if(!$person->id): ?>
                <div class="row">
                    <div class="form-group col-md-12">
                        <label><?php echo app('translator')->getFromJson('front.title'); ?></label>
                        <textarea class="form-control" name="comment"></textarea>
                    </div>
                </div>
            <?php endif; ?>
        </div>
        <!-- /.box-body -->
        <div class="box-footer">
            <button type="submit" class="btn btn-primary"><?php echo app('translator')->getFromJson('front.save'); ?></button>
        </div>
    </div>
</section>
<script>
    $('#datepicker').datepicker({
        autoclose: true,
        rtl: true,
        format: 'yyyy-mm-dd',
        language: "<?php echo e(\Session::get('locale')); ?>",

    });
    $(".select2").select2();


    $('#areasList').select2({
        ajax: {
            url: function() {
                return $(this).attr('data-url') + "?gov_id=" + $("#governmentList").val();
            },
            dataType: 'json',
            data: function(params) {
                return {
                    term: params.term // search term
                };
            },
            processResults: function(response) {
                return response;
            },
            cache: true,
            minimumInputLength: 1,
            width: "100%",
        }
    });
    $(".selectRegion").select2({
        tags: true,
        //selectOnClose: true,
        allowClear: true,
        createTag: function(params) {
            var term = $.trim(params.term);
            if (term === '') {
                return null;
            }
            return {
                id: term,
                text: term
            };
        }
    }).on('select2:select', function(evt) {
        $.ajax({
            type: "POST",
            url: "<?php echo e(route('regions.store')); ?>",
            data: {
                _token: "<?php echo e(csrf_token()); ?>",
                name: evt.params.data.text,
                type: 1
            },
            success: function(data) {
                $(".selectRegion").html(data);
            }
        });
    });
    $('input[type="checkbox"].flat-red, input[type="radio"].flat-red').iCheck({
        checkboxClass: 'icheckbox_flat-green',
        radioClass: 'iradio_flat-green'
    });
    $(document).on('click', '#is_client_supplier', function(e) {
        e.preventDefault();
        if ($('#is_client_supplier').is(':checked'))
            alert("checked");
        else
            alert("unchecke");
    });
</script>
<?php if(request()->req == 'ajax'): ?>
    <script>
        $(function() {
            $("#personForm").submit(function(e) {
                var form = $(this);
                var url = form.attr('action');
                e.preventDefault();
                $.ajax({
                    type: "POST",
                    url: url,
                    data: form.serialize(),
                    success: function(data) {
                        $("#personList").empty();
                        $("#personList").append(data);
                        $("#personList option:last").attr("selected", "selected");
                        $('#addPersonModal').modal('toggle');
                        //selectRefresh();
                        $("#personList").trigger('change');


                    }
                });
            });
        });
    </script>
<?php endif; ?>
