<section class="content">
    <div class="box box-primary">
        <div class="box-body">
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.name'); ?></label>
                            <input value="<?php echo e($employee->name); ?>" required name="name" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.telephone'); ?></label>
                            <input value="<?php echo e($employee->mobile); ?>" name="mobile" type="text" class="form-control">
                        </div>
                    </div>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.type'); ?></label>
                            <select name="type" class="form-control empType">
                                <option <?php echo e($employee->type=='normal'?'selected':''); ?> value="normal"><?php echo app('translator')->getFromJson('front.fulltime'); ?></option>
                                <option <?php echo e($employee->type=='sales'?'selected':''); ?> value="sales"><?php echo app('translator')->getFromJson('front.sale'); ?></option>
                                <option <?php echo e($employee->type=='markter'?'selected':''); ?> value="markter"><?php echo app('translator')->getFromJson('front.marketer'); ?></option>
                                <option <?php echo e($employee->type=='sales_manager'?'selected':''); ?>  value="sales_manager">مدير مبيعات</option>
                            </select>
                        </div>
                    </div>

                    <div id="salesManagerDiv" class="col-md-12 hide">
                        <div class="form-group">
                            <label>مدير المبيعات</label>
                            <select name="manager_id" class="form-control managerSelect">
                                <option value="">--- إختر مدير المبيعات ---</option>
                                <?php $__currentLoopData = \App\Employee::where('type','sales_manager')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $man): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e($employee->manager_id==$man->id?'selected':''); ?> value="<?php echo e($man->id); ?>"><?php echo e($man->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                             </select>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label>التارجت</label>
                            <input value="<?php echo e($employee->target); ?>" name="target" type="number" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.Salary'); ?></label>
                            <input value="<?php echo e($employee->salary); ?>" name="salary" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-3">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.percentage'); ?></label>
                        <div class="input-group">
                            <div class="input-group-addon">
                                <i class="fa fa-pie-chart"></i>
                            </div>
                            <input value="<?php echo e($employee->percent?:0); ?>" name="percent" step="0.01" type="number" class="form-control pull-right">
                            <div class="input-group-addon">
                                %
                            </div>
                        </div>
                    </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.working days'); ?></label>
                            <input value="<?php echo e($employee->working_days); ?>" name="working_days" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-3">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.Daily salary'); ?></label>
                            <input value="<?php echo e($employee->day_salary); ?>" name="day_salary" type="text" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.notes'); ?></label>
                            <textarea name="note" class="form-control"><?php echo e($employee->note); ?></textarea>
                        </div>
                    </div>
                <!-- /.row -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <button type="submit" class="btn btn-primary"><?php echo app('translator')->getFromJson('front.save'); ?></button>
            </div>
        </div>
    </div>
</section>
<script>
    $(document).on("change",'.empType',function(){
        if($(this).val()=='sales'){
            $("#salesManagerDiv").removeClass('hide');
        }else{
            $(".managerSelect").val('');
            $("#salesManagerDiv").addClass('hide');
        }
    });
    $(".empType").trigger("change");
    $('.select2').select2();
    $('form').validator();
</script>
