<section class="content">
    <div class="box box-primary">
            <div class="box-body">
                <div class="row">
                    <div class="col-md-12">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.name'); ?></label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-user"></i>
                                </div>
                                <input value="<?php echo e($user->name); ?>" required name="name" type="text" class="form-control pull-right">
                            </div>
                            <!-- /.input group -->
                        </div>
                    </div>
                    <div class="col-md-12 <?php echo e(!auth()->user()->can('destroy RolesController')?'hide':''); ?>">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.role'); ?></label>
                            <select name="role" class="form-control">
                                <?php $__currentLoopData = \App\Role::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php if($user->id && optional($user->roles()->first())->id==$role->id): ?> selected="" <?php endif; ?> value="<?php echo e($role->id); ?>"><?php echo e($role->display_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.username'); ?></label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-user-plus"></i>
                                </div>
                                <input value="<?php echo e($user->email); ?>" required name="email" type="text" class="form-control">
                            </div>
                            <!-- /.input group -->
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.password'); ?></label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-user-secret"></i>
                                </div>
                                <input value="" name="password" type="password" class="form-control">
                            </div>
                            <!-- /.input group -->
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label for=""><?php echo app('translator')->getFromJson('front.stores'); ?></label>
                            <select style="width: 100%;" multiple name="stores[]" class="form-control select2" required="required">
                                <?php $__currentLoopData = \App\Store::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e($user->stores_ids?(in_array($s->id,$user->stores_ids)?'selected':''):''); ?>  value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.Choose a safe'); ?></label>
                            <select required name="treasury_id" class="form-control select2" style="width: 100%;">
                                <option value="">  <?php echo app('translator')->getFromJson('front.select'); ?> </option>
                                <?php $__currentLoopData = \App\Bank::where('type',2)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tresury): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(($tresury->id==$user->treasury_id)?'selected':''); ?> value="<?php echo e($tresury->id); ?>"><?php echo e($tresury->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <?php if(auth()->user()->can('destroy RolesController')): ?>
                        <div class="form-group col-md-6">
                            <label>
                                <input <?php if($user->show_cost_price): ?> checked <?php endif; ?> class="flat-red" name="show_cost_price" type="checkbox">
                                عرض سعر التكلفة
                            </label>
                        </div>
                        <div class="form-group col-md-6">
                            <label>
                                <input <?php if($user->show_sale_price): ?> checked <?php endif; ?> class="flat-red" name="show_sale_price" type="checkbox">
                                عرض سعر البيع
                            </label>
                        </div>
                    <?php endif; ?>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>Photo</label>
                            <input type="file" class="form-control" name="photo">
                            <?php if(optional($user->getFirstMedia('photo'))->getUrl()): ?>
                                <img class="profile-user-img img-responsive img-circle" src="<?php echo e(optional($user->getFirstMedia('photo'))->getUrl()); ?>" alt="User profile picture">
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
                <!-- /.row -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <button type="submit" class="btn btn-primary"><?php echo app('translator')->getFromJson('front.save'); ?></button>
            </div>
        </div>
</section>
<script>
    $('form').validator();
    $('.select2').select2();
</script>
