<?php $__env->startSection('title', trans('front.summary') . ' ' . $person->name); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <?php echo app('translator')->getFromJson('front.summary'); ?>
            <small>
                <?php echo e($person->name); ?>

            </small>
            <a onclick="window.print();" href="javascript:void(0)" class="btn btn-info  print pull-right"><i class="fa fa-print"
                    aria-hidden="true"></i> طباعة</a>
            <button id="pdf-button" class="btn btn-success print-window pull-right"><i class="fa fa-file-pdf-o"
                    aria-hidden="true"></i> تحميل PDF</button>
        </h1>
        <?php echo $__env->make('layouts.partial.filter', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
    </section>
    <!-- Main content -->
    <section class="content">
        <?php echo $__env->make('layouts.partial.printHeader', ['showCompanyData' => true], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <div class="row">
            <div class="col-md-12">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <div class="row">
                            <div class="col-md-4">
                                <h3 class="box-title"> كشف حساب <?php echo e($person->name); ?></h3>
                            </div>
                            <div class="col-md-4">
                                <p><strong>الرصيد الحالي: </strong> <?php echo $person->balnce_text; ?></p>
                                <p><strong>عدد الفواتير: </strong> <?php echo e(count($orders)); ?></p>
                            </div>
                            <div class="col-md-4">
                                <p><strong>الفترة من:</strong> <?php echo e(request('fromdate')); ?></p>
                                <p><strong>الفترة إلي:</strong> <?php echo e(request('todate')); ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>البيان</th>
                                            <th>فاتورة</th>
                                            <th>التاريخ</th>
                                            <th>دائن</th>
                                            <th>مدين</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perTrans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?> </td>
                                                <td><?php echo e($perTrans->note); ?></td>
                                                <td>
                                                    <?php if($perTrans->record_id): ?>
                                                        <table class="table table-hover">
                                                            <thead>
                                                                <tr>
                                                                    <th>الصنف</th>
                                                                    <th>الكمية</th>
                                                                    <th>السعر</th>
                                                                    <th>الاجمالي</th>
                                                                    <th>الملاحظات</th>
                                                                </tr>
                                                            </thead>
                                                            <tbody>
                                                                <?php
                                                                    $order = $perTrans->order;
                                                                ?>
                                                                <?php if($perTrans->order): ?>
                                                                    <?php $__currentLoopData = $order->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <?php
                                                                            $tqty = $item->pivot->qty;
                                                                            $tval = $tqty * $item->pivot->price;
                                                                        ?>
                                                                        <tr>
                                                                            <td><?php echo e($item->full_name); ?></td>
                                                                            <td><?php echo e($tqty . ' ' . $item->pivot->unit_name); ?>

                                                                            </td>
                                                                            <td><?php echo e($item->pivot->price); ?></td>
                                                                            <td><?php echo e(number_format($tval, 2)); ?></td>
                                                                            <td><?php echo e($order->note); ?></td>
                                                                        </tr>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <?php endif; ?>
                                                            </tbody>
                                                        </table>
                                                    <?php endif; ?>
                                                </td>
                                                <td>
                                                    <?php echo e($perTrans->created_at ? $perTrans->date_ar : ''); ?></td>
                                                <td><?php echo e($perTrans->value < 0 ? number_format(abs($perTrans->value), 2) : '------'); ?>

                                                </td>
                                                <td><?php echo e($perTrans->value > 0 ? number_format($perTrans->value, 2) : '------'); ?>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .table tr>td,
        .table tr>th {
            text-align: center;
            white-space: normal;
            word-wrap: break-word;
        }

        tr td,
        tr th {
            vertical-align: middle !important;
        }

        @media  print {

            .col-md-1,
            .col-md-2,
            .col-md-3,
            .col-md-4,
            .col-md-5,
            .col-md-6,
            .col-md-7,
            .col-md-8,
            .col-md-9,
            .col-md-10,
            .col-md-11,
            .col-md-12 {
                float: left;
            }

            .col-md-12 {
                width: 100%;
            }

            .col-md-11 {
                width: 91.66666667%;
            }

            .col-md-10 {
                width: 83.33333333%;
            }

            .col-md-9 {
                width: 75%;
            }

            .col-md-8 {
                width: 66.66666667%;
            }

            .col-md-7 {
                width: 58.33333333%;
            }

            .col-md-6 {
                width: 50%;
            }

            .col-md-5 {
                width: 41.66666667%;
            }

            .col-md-4 {
                width: 33.33333333%;
            }

            .col-md-3 {
                width: 25%;
            }

            .col-md-2 {
                width: 16.66666667%;
            }

            .col-md-1 {
                width: 8.33333333%;
            }
        }
    </style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>