<?php
if(isset($employee_id)){
    $expense->employee_id = $employee_id;
}
?>
<section class="content">
    <div class="box box-primary">
        <div class="box-body">
                <div class="row">
                    <div class="col-md-6">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.date'); ?></label>
                        <div class="input-group date">
                            <div class="input-group-addon">
                                <i class="fa fa-calendar"></i>
                            </div>
                            <input name="created_at" type="text" value="<?php echo e(($expense->created_at)?$expense->created_at->format('Y-m-d'):date('Y-m-d')); ?>" class="form-control pull-right" id="datepicker">
                        </div>
                        <!-- /.input group -->
                    </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.title'); ?></label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-edit"></i>
                                </div>
                                <input value="<?php echo e($expense->note); ?>" required name="note" type="text" class="form-control pull-right">
                            </div>
                            <!-- /.input group -->
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.tax'); ?></label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    %
                                </div>
                                <input id="TaxValue" name="tax_value" value="<?php echo e(old('tax_value')??($expense->tax_value ?? 0)); ?>" class="hide">
                                <input id="TaxVal" required value="<?php echo e(old('tax')??($expense->tax ?? $settings['taxValue'])); ?>" name="tax" type="number" class="form-control pull-right">
                            </div>
                            <!-- /.input group -->
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>المبلغ قبل الضريبة</label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-money"></i>
                                </div>
                                <input id="ValueBefore" required value="<?php echo e($expense->value_before_tax??0); ?>" step="0.01" type="number" class="form-control pull-right">
                            </div>
                            <!-- /.input group -->
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label>المبلغ بعد الضريبة</label>
                            <div class="input-group">
                                <div class="input-group-addon">
                                    <i class="fa fa-money"></i>
                                </div>
                                <input id="ValueAfter" readonly value="<?php echo e($expense->value); ?>" name="value" type="number" class="form-control pull-right">
                            </div>
                            <!-- /.input group -->
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.Choose a safe'); ?></label>
                            <select name="bank_id" class="form-control ">
                                <?php $__currentLoopData = \App\Bank::where('id',auth()->user()->treasury_id)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option balance="<?php echo e($bank->balance); ?>"  value="<?php echo e($bank->id); ?>"><?php echo e($bank->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-12 <?php echo e($employee_id?'hide':''); ?>">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.expense'); ?></label>
                            <select style="width: 100%;" name="partner_id" class="form-control select2">
                                <option <?php echo e(($expense->partner_id=='')?'selected':''); ?>  value=""><?php echo app('translator')->getFromJson('front.general'); ?></option>
                                <?php $__currentLoopData = \App\Partner::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(($expense->partner_id==$partner->id)?'selected':''); ?> value="<?php echo e($partner->id); ?>"><?php echo e($partner->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-12">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.Expense Type'); ?></label>
                            <select required style="width: 100%;" name="expenses_type_id" class="form-control select2">
                                <option value=""><?php echo app('translator')->getFromJson('front.select'); ?></option>
                                <?php $__currentLoopData = \App\ExpensesType::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(($expense->expenses_type_id==$type->id)?'selected':''); ?> value="<?php echo e($type->id); ?>"><?php echo e($type->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>


                    <div class="col-md-12 <?php echo e($employee_id?'':'hide'); ?>">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.employee'); ?></label>
                            <input class="form-control" type="hidden" name="employee_id" value="<?php echo e(isset($employee_id) ? $employee_id : ''); ?>">
                            <select disabled="" style="width: 100%;" name="employee_id" class="form-control select2">
                                <option value=""><?php echo app('translator')->getFromJson('front.select'); ?></option>
                                <?php $__currentLoopData = \App\Employee::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(($expense->employee_id==$emp->id)?'selected':''); ?> value="<?php echo e($emp->id); ?>"><?php echo e($emp->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                <!-- /.row -->
            </div>
            <!-- /.box-body -->
            <div class="box-footer">
                <button type="submit" class="btn btn-primary"><?php echo app('translator')->getFromJson('front.save'); ?></button>
            </div>
        </div>
    </div>
</section>
<script>
    $('.select2').select2();
    $('form').validator();

    $('#datepicker').datepicker({
        autoclose: true,
        rtl: true,
        format: 'yyyy-mm-dd',
        language: "<?php echo e(\Session::get('locale')); ?>",
    });
    $(document).on("input","#ValueBefore,#ValueAfter,#TaxVal",function(e){
        var grandtotal = parseFloat($("#ValueBefore").val());
        var tax = parseFloat($("#TaxVal").val());
        var TaxValue = (grandtotal * (tax / 100));
        $("#TaxValue").val(TaxValue);
        grandtotal += TaxValue;
        grandtotal = parseFloat(grandtotal).toFixed(2);
        $("#ValueAfter").val(grandtotal)
    });

</script>
