<?php $__env->startSection('content'); ?>
<?php $__env->startSection('title','بيان اﻷرباح'); ?>
<section class="content-header">
	<h1>
		<?php echo app('translator')->getFromJson('front.report'); ?>
		<small>
			<?php echo app('translator')->getFromJson('front.profits'); ?>
		</small>
		<a class="btn print-window pull-right" href="javascript:void(0)" onclick="window.print()" role="button">
			<i class="fa fa-print" aria-hidden="true"></i>
		</a>
	</h1>
</section>
<section class="content">
	<div class="box box-primary">
		<?php echo $__env->make('layouts.partial.filter', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
		<?php echo $__env->make('layouts.partial.printHeader',['showCompanyData'=>true], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <form action="<?php echo e(route('partners.addProfitToPartner')); ?>" method="post">
            <?php echo csrf_field(); ?>
            <div class="box-body row" style=" overflow: auto; width: 100%;">
                <div class="col-md-12">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th><?php echo app('translator')->getFromJson('front.name'); ?></th>
                                <th><?php echo app('translator')->getFromJson('front.percentage'); ?></th>
                                <th><?php echo app('translator')->getFromJson('front.total profits'); ?></th>
                                <th><?php echo app('translator')->getFromJson('front.general expenses'); ?></th>
                                <th><?php echo app('translator')->getFromJson('front.grand profit'); ?></th>
                                <th>مسحوبات</th>
                                <th>تسويات</th>
                                <th><?php echo app('translator')->getFromJson('front.partner profit'); ?></th>
                                <th><?php echo app('translator')->getFromJson('front.grand profit'); ?></th>
                                <th>الربح النهائي</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                                $from= request()->fromdate;
                                $to= request()->todate;
                            ?>
                            <?php $__currentLoopData = $partners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $partner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $sptialExpenses = $partner->expenses;
                                    $partnerprofit = $partner->partnerprofit;
                                    $sptial = $sptialExpenses->sum('value');
                                    $taswia = $partnerprofit->sum('value');
                                    $partnerProfit = $grandProfit * ($partner->percent/100);
                                    $myprofit = $partnerProfit - $sptial  ;
                                    // if($myprofit){
                                    //     $myprofit -= $taswia;
                                    // }
                                    $finalProfit = $myprofit + $taswia ;

                                ?>
                                <tr>
                                    <td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($partner->name); ?></td>
                                    <td><?php echo e($partner->percent); ?> %</td>
                                    <?php if($loop->iteration==1): ?>
                                        <td class="bg-green rowTd" rowspan="<?php echo e(count($partners)); ?>"><?php echo e(currency(round($totalProfit,2),currency()->config('default'),currency()->config('default'), true)); ?></td>
                                        <td class="bg-red rowTd" rowspan="<?php echo e(count($partners)); ?>"><?php echo e(currency(round($generalExpenses,2),currency()->config('default'),currency()->config('default'), true)); ?></td>
                                        <td class="bg-primary rowTd" rowspan="<?php echo e(count($partners)); ?>"><?php echo e(currency(round($grandProfit,2),currency()->config('default'),currency()->config('default'), true)); ?></td>
                                    <?php endif; ?>
                                    <td class="warning"><?php echo e($sptial); ?></td>
                                    <td><?php echo e($taswia); ?></td>
                                    <td class="info"><?php echo e(currency(round($partnerProfit,2),currency()->config('default'),currency()->config('default'), true)); ?></td>
                                    <td class="success">
                                        <input type="hidden" name="grandProfit" value="<?php echo e($grandProfit); ?>"/>
                                        <input type="hidden" name="partner[<?php echo e($loop->iteration); ?>][id]" value="<?php echo e($partner->id); ?>"/>
                                        <input type="hidden" name="partner[<?php echo e($loop->iteration); ?>][profit]" value="<?php echo e(round($myprofit,2)); ?>"/>
                                        <?php echo e(currency(round($myprofit,2),currency()->config('default'),currency()->config('default'), true)); ?>

                                    </td>
                                    <td><?php echo e(round($finalProfit,2)); ?></td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="box-footer">
                <button class="btn btn-sm btn-warning" type="submit"><i class="fa fa-save"></i> تسوية الارياح </button>
                <a href="<?php echo e(route('taswia')); ?>" class="btn btn-success"><i class="fa fa-file"></i> تقرير التسويات</a>
            </div>
        </form>
	</div>
</section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .rowTd{
            vertical-align: middle !important;
            text-align: center !important;
            font-size: 15px !important;
        }
        .progress-bar,.badge{
            width: 100%;
        }
        .badge {
            width: 100%;
            padding: 5px;
        }
        table,.badge,td {
            font-size: 14px !important;
            font-weight: bold !important;
        }
        @media  print {
            table,.badge,td,.bg-green,.bg-yellow,.bg-aqua,.bg-red,.bg-green {
                font-size: 18px !important;
                color: #0c0c0c!important;
            }

        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('js'); ?>
	<script>
        $('.datepicker').datepicker({
            autoclose: true,
            rtl: true,
            format: 'yyyy-mm-dd',
            language: "<?php echo e(\Session::get('locale')); ?>",
        });
	</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>