<?php $__env->startSection('title', 'الحجوزات'); ?>
<?php $__env->startSection('content'); ?>
    <section class="content">
        <div class="row">
            <div class="col-md-6">
                <div class="box box-solid">
                    <div class="box-header with-border">
                        <h3 class="box-title">اضافة حجز جديد</h3>
                    </div>
                    <div class="box-body">
                        <form action="<?php echo e(route('orders.store')); ?>" method="post">
                            <?php echo e(csrf_field()); ?>

                            <input type="hidden" name="ispos" value="1">
                            <input type="hidden" value="bookings" name="order[invoice_type]">


                            <div class="hide">
                                <div class="form-group">
                                    <label><?php echo app('translator')->getFromJson('front.status'); ?></label>
                                    <select data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>" name="order[status]"
                                        class="form-control select2 " style="width:100%;">
                                        <option selected value="delivered"><?php echo app('translator')->getFromJson('front.delivered'); ?></option>
                                        <option value="not-delivered"><?php echo app('translator')->getFromJson('front.not-delivered'); ?></option>
                                    </select>
                                </div>
                            </div>
                            <input id="savePrint" name="savePrint" value="" type="hidden">
                            <div class="row">

                                <div class="col-md-12">
                                    <div class="box box-primary">
                                        <div class="box-body">
                                            <div class="col-md-6 hide">
                                                <div class="form-group">
                                                    <label for=""><?php echo app('translator')->getFromJson('front.store'); ?></label>
                                                    <select id="productStores" class="form-control storeList"
                                                        required="required">
                                                        <?php $__currentLoopData = auth()->user()->stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?>

                                                            </option>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-6 hide">
                                                <div class="form-group">
                                                    <label><?php echo app('translator')->getFromJson('front.payment'); ?></label>
                                                    <select id="paymentMethod" data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>"
                                                        name="order[payment_type]" class="form-control select2 "
                                                        style="width:100%;">
                                                        <option value="cash">
                                                            <?php echo app('translator')->getFromJson('front.cash'); ?>
                                                        </option>
                                                        <option selected value="delayed">
                                                            <?php echo app('translator')->getFromJson('front.Postpaid'); ?></option>
                                                        <option value="visa"><?php echo app('translator')->getFromJson('front.visa'); ?></option>
                                                        <option
                                                            <?php echo e($settings['default_payment'] == 'link transfer' ? 'selected' : ''); ?>

                                                            value="link transfer">
                                                            <?php echo app('translator')->getFromJson('front.link transfer'); ?></option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <?php
                                                        $title = trans('front.client');
                                                        $defaultperson = \App\Person::whereIn('name', [
                                                            'عميل نقدي',
                                                            'عميل كاش',
                                                        ])->first();
                                                        $salesMan = \App\Employee::where('type', 'sales')->get();
                                                        $marktersMan = \App\Employee::where('type', 'markter')->get();
                                                        $userListRoute = route('person.getList', ['type' => 'client']);
                                                        $route = route('client.create', ['req' => 'ajax']);
                                                    ?>
                                                    <label>
                                                        <?php echo app('translator')->getFromJson('front.client'); ?> <span class="lastBalance"
                                                            style="color: red"></span>
                                                    </label>
                                                    <div class="input-group">
                                                        <select data-ajax--url="<?php echo e($userListRoute); ?>"
                                                            data-ajax--cache="true" data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>"
                                                            id="personList" name="order[client_id]" required
                                                            class="form-control select2">
                                                            <option data-mobile="" value=""><?php echo app('translator')->getFromJson('front.select'); ?>
                                                            </option>
                                                            <?php if(isset(old('order')['client_id']) && !empty(old('order')['client_id'])): ?>
                                                                <?php
                                                                    $per = \App\Person::find(old('order')['client_id']);
                                                                ?>
                                                                <option points="<?php echo e($per->total_points); ?>"
                                                                    data-mobile="<?php echo e($per->mobile . ' ' . $per->mobile2); ?>"
                                                                    last_transaction="<?php echo e($per->last_transaction); ?>"
                                                                    priceType="<?php echo e($per->priceType); ?>"
                                                                    rel="<?php echo e($per->total_due); ?>" selected
                                                                    value="<?php echo e($per->id); ?>"><?php echo e($per->name); ?>

                                                                </option>
                                                            <?php else: ?>
                                                                <?php if($defaultperson): ?>
                                                                    <option points="<?php echo e($defaultperson->total_points); ?>"
                                                                        data-mobile="<?php echo e($defaultperson->mobile . ' ' . $defaultperson->mobile2); ?>"
                                                                        last_transaction="<?php echo e($defaultperson->last_transaction); ?>"
                                                                        priceType="<?php echo e($defaultperson->priceType); ?>"
                                                                        rel="<?php echo e($defaultperson->total_due); ?>" selected
                                                                        value="<?php echo e($defaultperson->id); ?>">
                                                                        <?php echo e($defaultperson->name); ?>

                                                                    </option>
                                                                <?php endif; ?>
                                                            <?php endif; ?>
                                                        </select>
                                                        <div class="input-group-addon no-print" style="padding: 2px 5px;">
                                                            <a href="<?php echo e($route); ?>" class="external"
                                                                data-toggle="modal" data-target="#addPersonModal">
                                                                <i class="fa fa-2x fa-plus-circle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="box box-success">
                                            <div class="box-body">
                                                <div class="nav-tabs-vertical">
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <ul class="nav nav-tabs">
                                                                <li class="header"><i class="fa fa-th"></i>
                                                                    <?php echo app('translator')->getFromJson('front.categories'); ?></li>
                                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <li
                                                                        <?php if($loop->iteration == 1): ?> class="active" <?php endif; ?>>
                                                                        <a href="#tab-<?php echo e($category->id); ?>"
                                                                            data-toggle="tab"><?php echo e($category->name); ?></a>
                                                                    </li>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                            </ul>
                                                        </div>
                                                        <div class="col-md-8">
                                                            <div class="tab-content">

                                                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <div style="padding: 10px"
                                                                        class="tab-pane <?php echo e($loop->iteration == 1 ? 'active' : ''); ?>"
                                                                        id="tab-<?php echo e($category->id); ?>">
                                                                        <?php $__currentLoopData = $category->productsservices->chunk(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="row">
                                                                                <?php $__currentLoopData = $chunks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <?php echo $__env->make(
                                                                                        'orders.item_card',
                                                                                        ['col' => 4]
                                                                                    , array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                        <?php $__currentLoopData = $category->productsservicesSubCategory->chunk(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $chunks): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="row">
                                                                                <?php $__currentLoopData = $chunks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                    <?php echo $__env->make(
                                                                                        'orders.item_card',
                                                                                        ['col' => 2]
                                                                                    , array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                                                    </div>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                <!-- /.tab-pane -->
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- /.tab-content -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="box box-warning">
                                            <div class="box-body">
                                                <table class="table table-bordered table-responsive">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>الخدمة</th>
                                                            <th class="hide">الكمية</th>
                                                            <th class="hide">الوحدة</th>
                                                            <th>السعر</th>
                                                            <th class="hide">الاجمالي</th>
                                                            <th>ملحوظة</th>
                                                            <th>الموظف</th>
                                                            <th>التاريخ/الوقت</th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="invoiceTable">
                                                    </tbody>
                                                </table>

                                            </div>
                                            <div class="box-footer">
                                                <button type="submit" class="btn btn-primary "><i
                                                        class="fa fa-save"></i>
                                                    <?php echo app('translator')->getFromJson('front.save'); ?> </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-12 hide">
                                    <div class="box box-primary">
                                        <div class="box-body">
                                            <table class="table table-bordered pull-right">
                                                <tr>
                                                    <td>
                                                        <label>
                                                            <?php echo app('translator')->getFromJson('front.total'); ?>:-
                                                        </label>
                                                        <input readonly id="total" value="" value="0"
                                                            class="form-control">
                                                    </td>
                                                    <td>
                                                        <label>
                                                            <?php echo app('translator')->getFromJson('front.discount'); ?>:-
                                                        </label>
                                                        <div class="input-group">
                                                            <input type="number" step="0.01" required id="discount"
                                                                name="order[discount]" value="0"
                                                                class="form-control">
                                                            <input type="hidden" name="order[discount_value]"
                                                                value="0">

                                                            <span class="input-group-addon ">
                                                                <input id="discount_type" value="1"
                                                                    name="order[discount_type]" type="checkbox"
                                                                    class="flat-red ">
                                                                %
                                                            </span>
                                                            <span style="color:#ffffff;" id="disValue"
                                                                class="input-group-addon btn ">

                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <label>
                                                            <?php echo app('translator')->getFromJson('front.tax'); ?>:-
                                                        </label>
                                                        <input id="TaxValue" name="order[tax_value]" value="0"
                                                            class="hide">
                                                        <div class="input-group">
                                                            <input id="tax" name="order[tax]"
                                                                value="<?php echo e($settings['taxValue'] ?? 0); ?>"
                                                                class="form-control">
                                                            <span class="input-group-addon btn">
                                                                %
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <label>
                                                            <?php echo app('translator')->getFromJson('front.grand'); ?>:
                                                        </label>
                                                        <input readonly id="totalafter" value=""
                                                            name="order[total]" value="0" class="form-control">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <label>
                                                            <?php echo app('translator')->getFromJson('front.paid'); ?>:-
                                                        </label>
                                                        <input type="number" step="0.01" required id="paid"
                                                            name="order[paid]" value="0" class="form-control" />
                                                    </td>
                                                    <td>
                                                        <label>
                                                            <?php echo app('translator')->getFromJson('front.due'); ?>:-
                                                        </label>
                                                        <div class="input-group">
                                                            <input readonly required id="due" name="order[due]"
                                                                value="0" class="form-control" />
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <label>
                                                            <?php echo app('translator')->getFromJson('front.before'); ?>:-
                                                        </label>
                                                        <input readonly required id="lastBalance" value="0"
                                                            class="form-control">
                                                    </td>
                                                    <td>
                                                        <label>
                                                            <?php echo app('translator')->getFromJson('front.balance'); ?>:-
                                                        </label>
                                                        <input readonly required id="totalBalance" value=""
                                                            class="form-control">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td colspan="4">
                                                        <button type="submit" class="btn btn-primary "><i
                                                                class="fa fa-save"></i>
                                                            <?php echo app('translator')->getFromJson('front.save'); ?> </button>
                                                        <button type="submit" class="btn btn-success saveandPrint"><i
                                                                class="fa fa-print"></i> <?php echo app('translator')->getFromJson('front.save and print'); ?> </button>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <div class="row" style="margin-top: 10px; margin-right: -5px;">
                            <?php
                                $statusList = [
                                    'معلق' => '#FF9800',
                                    'جارى العمل' => '#337ab7',
                                    'مكتمله' => '#008d4c',
                                    'مؤجله' => '#d73925',
                                ];
                            ?>
                            <?php $__currentLoopData = $statusList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $color): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-md-3">
                                    <i style="color: <?php echo e($color); ?>;" class="fa fa-square fa-2x"></i> <span
                                        class="colortextspan"><?php echo e($key); ?></span>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <div class="box-body no-padding">
                        <div class="row">
                            <div class="col-md-12">
                                <iframe width="100%" height="800px" frameborder="0"
                                    src="<?php echo e(route('reservations.schedule')); ?>"></iframe>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /. box -->
            </div>
            <!-- /.col -->
        </div>
    </section>


<?php $__env->stopSection(); ?>


<?php echo $__env->make('reservations._book_script', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>