<?php if($settings['industrial'] == 3 && $order->invoice_type == 'sales'): ?>
    <?php echo $__env->make('orders.show_pharma', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php else: ?>
    <section class="content-header hideprint">
        <h1>
            <?php echo app('translator')->getFromJson('front.orderdetails'); ?>
            <small>
                <?php echo e($order->invoice_number); ?>

            </small>
            <button type="button" class="close" data-dismiss="modal" aria-hidden="true"><i
                    class="fa fa-times"></i></button>
        </h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <div class="col-md-12">
                <h1>
                    <a class="btn print-window pull-right" href="javascript:void(0)"
                        onclick="PrintElem('<?php echo e(route('orders.getPrint', $order->id)); ?>')" role="button">
                        <i class="fa fa-print" aria-hidden="true"></i>
                    </a>
                    <a class="btn print-window pull-right" href="<?php echo e(route('order.create', ['notpopup' => 'yes'])); ?>"
                        role="button">
                        <i class="fa fa-backward" aria-hidden="true"></i> رجوع
                    </a>
                </h1>
            </div>
            <div class="col-md-12">
                <div id="printInvoice" class="box" style="border: none;">
                    <div class="box-body" style="max-width: 290mm!important;">
                        <div class="col-md-12">
                            <div style="font-weight: bold;font-size: <?php echo e($settings['PrintSize'] + 2); ?>px!important;"
                                class="invoice-title">

                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="pull-left">
                                            <span style="font-size: 20px; "><?php echo $settings['SiteName']; ?></span><br />
                                            <?php if($settings['taxNumber']): ?>
                                                <span style="font-size: 16px; "> الرقم الضريبى:
                                                    <?php echo e($settings['taxNumber']); ?></span><br />
                                            <?php endif; ?>
                                            <?php if($settings['Address']): ?>
                                                <span style="font-size: 16px; "><?php echo $settings['Address']; ?></span><br />
                                            <?php endif; ?>
                                            <?php if($settings['mobile']): ?>
                                                <span style="font-size: 16px; "><?php echo e($settings['mobile']); ?></span><br />
                                            <?php endif; ?>
                                            تاريخ الطباعه : <?php echo e(date('Y-m-d')); ?><br />
                                            مسئول الطباعه : <?php echo e(auth()->user()->name); ?>

                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <?php if($settings['logo']): ?>
                                            <div class="text-center">
                                                <img style="width: 155px;"
                                                    src="<?php echo e(\Illuminate\Support\Facades\Storage::url($settings['logo'])); ?>">
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                    <div class="col-md-4">
                                        <h5 style="line-height: 25px;font-size: <?php echo e($settings['PrintSize'] + 2); ?>px!important;"
                                            class="pull-right"><?php echo app('translator')->getFromJson('front.invoicenumber'); ?> : <?php echo e($order->invoice_number); ?><br>
                                            <?php
                                                $clientDetailes = optional($order->client);
                                            ?>
                                            <?php echo app('translator')->getFromJson('front.client'); ?> : <?php echo e($clientDetailes->name); ?> <br />
                                            <?php if($order->sale_id): ?>
                                                <?php echo app('translator')->getFromJson('front.sale'); ?> : <?php echo e(optional($order->saleMan)->name); ?><br />
                                            <?php endif; ?>
                                            <?php if($clientDetailes->mobile): ?>
                                                <?php echo app('translator')->getFromJson('front.telephone'); ?> : <?php echo e($clientDetailes->mobile); ?> <br />
                                            <?php endif; ?>
                                            <?php if($clientDetailes->address): ?>
                                                <?php echo app('translator')->getFromJson('front.address'); ?> : <?php echo e($clientDetailes->address); ?> <br />
                                            <?php endif; ?>
                                            <?php if($clientDetailes->taxnumber): ?>
                                                الرقم الضريبي : <?php echo e($clientDetailes->taxnumber); ?> <br />
                                            <?php endif; ?>
                                            <?php echo app('translator')->getFromJson('front.payment'); ?> :
                                            <?php echo e(in_array($order->payment_type, ['cash', 'delayed']) ? trans('app.' . $order->payment_type) : $order->payment_type); ?>

                                            <br />
                                            <?php echo app('translator')->getFromJson('front.date'); ?> : <?php echo e($order->order_date); ?>

                                            <?php if($order->markter_id): ?>
                                                <br />
                                                <?php echo app('translator')->getFromJson('front.marketer'); ?> : <?php echo e(optional($order->market)->name); ?>

                                            <?php endif; ?>
                                        </h5>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12 text-center">


                            <?php if($order->invoice_type == 'sales'): ?>
                                <h3
                                    style="border-bottom: 1px solid grey;border-top: 1px solid grey;padding-bottom:10px;padding-top: 10px;">
                                    فاتورة ضريبية</h3>
                                <h3>
                                    <?php echo app('translator')->getFromJson('front.order'); ?> <?php if($order->is_withdrawable == 1): ?>
                                        | مسحوبات
                                    <?php endif; ?>
                                <?php elseif($order->invoice_type == 'bookings'): ?>
                                    <h3
                                        style="border-bottom: 1px solid grey;border-top: 1px solid grey;padding-bottom:10px;padding-top: 10px;">
                                        حجز موعد
                                    </h3>
                                <?php else: ?>
                                    <?php echo app('translator')->getFromJson('front.purchase'); ?>
                            <?php endif; ?>
                            # <?php echo e($order->invoice_number); ?>

                            </h3>
                            <?php
                                $colspan = 4;
                            ?>
                            <table style="max-width: 270mm!important;" class="table table-bordered">
                                <thead>
                                    <tr>
                                        <td>#</td>
                                        <td class="col-md-4"><?php echo app('translator')->getFromJson('front.product'); ?></td>
                                        <td>الموظف</td>
                                        <?php if($settings['show_category_in_invoice'] == 1): ?>
                                            <td><?php echo app('translator')->getFromJson('front.parent'); ?></td>
                                            <?php
                                                $colspan++;
                                            ?>
                                        <?php endif; ?>
                                        <?php if($settings['show_stores_in_invoices'] == 1): ?>
                                            <td><?php echo app('translator')->getFromJson('front.store'); ?></td>
                                            <?php
                                                $colspan++;
                                            ?>
                                        <?php endif; ?>
                                        <td><?php echo app('translator')->getFromJson('front.unit'); ?></td>
                                        <td><?php echo app('translator')->getFromJson('front.quantity'); ?></td>
                                        <td>البيع</td>
                                        <?php if($order->invoice_type == 'sales' && isset($settings['ShowCustomerPrice']) && $settings['ShowCustomerPrice'] == 1): ?>
                                            <?php
                                                $colspan++;
                                            ?>
                                            <td><?php echo app('translator')->getFromJson('front.customer_price'); ?></td>
                                        <?php endif; ?>

                                        <?php if($settings['use_bounse'] == 1): ?>
                                            <td><?php echo app('translator')->getFromJson('front.bounse'); ?></td>
                                            <?php
                                                $colspan++;
                                            ?>
                                        <?php endif; ?>
                                        <td class="col-md-2"><?php echo app('translator')->getFromJson('front.total'); ?></td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $totalQty = 0;
                                    ?>
                                    <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $tqty = $item->qty;
                                            $tval = $tqty * $item->price;
                                            $totalQty += $tqty;
                                            $product = optional($item->product);
                                        ?>
                                        <tr>
                                            <td>
                                                <?php echo e($loop->iteration); ?>

                                                <img style="width: 20px;" class="stateIcon"
                                                    src="<?php echo e($item->status ? asset('icons/yes.png') : asset('icons/no.png')); ?>" />
                                            </td>
                                            <td>
                                                <?php echo e($product->full_name); ?>

                                                <br />
                                                <b><?php echo e($item->comment); ?></b>
                                            </td>
                                            <td><?php echo e(optional($item->employee)->name); ?></td>
                                            <?php if($settings['show_category_in_invoice'] == 1): ?>
                                                <td><?php echo e(optional($product->category)->name); ?></td>
                                            <?php endif; ?>
                                            <?php if($settings['show_stores_in_invoices'] == 1): ?>
                                                <td><?php echo e($item->store_name); ?></td>
                                            <?php endif; ?>
                                            <td><?php echo e($item->unit_name); ?></td>
                                            <td>
                                                <span style="font-weight: bold;"> <?php echo e($tqty); ?> </span>
                                                <?php if((int) $item->return_qty): ?>
                                                    <span
                                                        style="color: red;font-size: 10px;">(<?php echo e($item->return_qty); ?>

                                                        مرتجع) </span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php echo e(currency($item->price, $order->currency, currency()->getUserCurrency(), $format = false)); ?>

                                            </td>
                                            <?php if($order->invoice_type == 'sales' && isset($settings['ShowCustomerPrice']) && $settings['ShowCustomerPrice'] == 1): ?>
                                                <td><?php echo e($item->customer_price); ?></td>
                                            <?php endif; ?>
                                            <?php if($settings['use_bounse'] == 1): ?>
                                                <td><?php echo e($item->bounse); ?> <?php echo e($item->bounseUnitText); ?></td>
                                            <?php endif; ?>
                                            <td>
                                                <?php echo e(currency($tval, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                </tbody>
                                <tfoot>
                                    <tr>
                                        <td style="border: none!important;" colspan="<?php echo e($colspan); ?>">
                                            <div class="row">
                                                <div class="col-md-12">
                                                    <p class="pull-left">استلمت الاصناف المذكوره عاليه بحالة جيدة
                                                        وبالكميات
                                                        المحدده</p>
                                                </div>
                                                <div class="clearfix"></div>
                                                <div class="col-md-12">
                                                    <p class="pull-left">
                                                        إجمالى الكميات : <?php echo e($totalQty); ?>

                                                    </p>
                                                </div>
                                                <div class="clearfix"></div>
                                                <div class="col-md-12">
                                                    <p class="pull-left">
                                                        توقيع المندوب :
                                                    </p>
                                                </div>
                                                <div class="clearfix"></div>
                                                <div class="col-md-12">
                                                    <p class="pull-left">
                                                        توقيع المستلم :
                                                    </p>
                                                </div>

                                                <div class="clearfix"></div>
                                                <div style="direction: rtl" class="col-md-12">
                                                    <?php echo $settings['InvoiceNotes']; ?>

                                                </div>
                                                <?php if(isset($order->note) && !empty($order->note)): ?>
                                                    <div class="clearfix"></div>
                                                    <div style="direction: rtl" class="col-md-12">
                                                        <?php echo e($order->note); ?>

                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                        <td style="border: none!important;" colspan="3">
                                            <table class="table table-bordered">
                                                <tbody>
                                                    <tr>
                                                        <td class="no-line text-center">الاجمالي قبل الضريبة :
                                                            <?php echo e(currency($order->total_without_tax, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                                        </td>
                                                        <td class="no-line text-center"><?php echo app('translator')->getFromJson('front.discount'); ?> :

                                                            <?php
                                                                $discount = 0;
                                                                $dist = $order->discount;
                                                                if ($order->discount) {
                                                                    if ($order->discount_type == 2) {
                                                                        $discount =
                                                                            $order->total * ($order->discount / 100);
                                                                        $dist = $discount;
                                                                        //$dist = "%".$order->discount. " ( $discount )";
                                                                    }
                                                                }
                                                            ?>
                                                            <?php echo e(currency($dist, $order->currency, currency()->getUserCurrency(), $format = true)); ?>


                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <td class="no-line text-center">قيمة الضريبة :
                                                            <?php echo e(round($order->tax_value, 2)); ?></td>

                                                        <td class="no-line text-center">الإجمالي :
                                                            <?php echo e(currency($order->total, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                                        </td>

                                                    </tr>
                                                    <tr>
                                                        <td class="no-line text-center"><?php echo app('translator')->getFromJson('front.paid'); ?> :
                                                            <?php echo e(currency($order->getOriginal('paid'), $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                                        </td>
                                                        <td class="no-line text-center"><?php echo app('translator')->getFromJson('front.due'); ?> :
                                                            <?php echo e($order->due); ?> </td>
                                                        
                                                    </tr>
                                                    <?php if(false && $order->id == $order->client->latestOrder->id): ?>
                                                        <tr>
                                                            <td class="no-line text-center"><?php echo app('translator')->getFromJson('front.before'); ?> : </td>
                                                            <td class="no-line text-center">
                                                                <?php echo e(currency($order->client->total_due - $order->due, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                                            </td>
                                                        </tr>
                                                        <tr>
                                                            <td class="no-line text-center text-bold"><?php echo app('translator')->getFromJson('front.balance'); ?>
                                                                :
                                                            </td>
                                                            <td class="no-line text-center text-bold">
                                                                <?php echo e($order->client->balnce_text); ?> </td>
                                                        </tr>
                                                    <?php endif; ?>
                                                    <tr>
                                                        <td colspan="2" style="border: none!important;">
                                                            <?php
                                                                $check = true;
                                                                try {
                                                                    $Qcode = $order->generatQrcode(
                                                                        $settings['SiteName'],
                                                                        $settings['taxNumber'],
                                                                        $order->order_date,
                                                                        $order->total,
                                                                        $order->tax_value,
                                                                    );
                                                                } catch (\Exception $e) {
                                                                    //dd($e->getMessage());
                                                                    $check = false;
                                                                }
                                                            ?>
                                                            <?php if($check && $Qcode): ?>
                                                                <div style="margin-bottom: 5px;">
                                                                    <img src="<?php echo e($Qcode); ?>">
                                                                </div>
                                                            <?php endif; ?>
                                                        </td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                        </td>
                                    </tr>
                                </tfoot>
                            </table>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>


    </section>
<?php endif; ?>
<style>
    #printInvoice .table tr>td {
        text-align: center;
        border: 2px solid #000 !important;
    }

    #printInvoice .table thead tr>td {
        font-weight: bold;
    }
</style>
