<?php if($type == 'sales'): ?>
    <input name="order[currency]" type="hidden" value="<?php echo e($order->currency ?: currency()->getUserCurrency()); ?>">
<?php endif; ?>
<input id="invoiceType" type="hidden" value="<?php echo e($type); ?>" name="order[invoice_type]">
<input id="savePrint" name="savePrint" value="" type="hidden">
<input id="saveandPrintBarcode" name="saveandPrintBarcode" value="" type="hidden">
<input id="bounse" type="hidden" value="0" class="form-control">
<input id="bounse_unit_id" type="hidden" value="0" class="form-control">
<input id="isService" type="hidden" value="0" class="form-control">

<section class="content">
    <div class="box box-primary">
        <div class="box-body">
            <div class="row">
                <div class="col-md-12">
                    <?php
                        $useMarket = false;
                        if ($settings['sales_marketer'] == 1 && $type == 'sales') {
                            $useMarket = true;
                        }
                        $employees = \App\Employee::pluck('name', 'id');
                    ?>
                    <div class="<?php echo e($type == 'sales' && $useMarket ? 'col-md-3' : 'col-md-4'); ?>">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.date'); ?></label>
                            <div class="input-group date">
                                <div class="input-group-addon">
                                    <i class="fa fa-calendar"></i>
                                </div>
                                <input readonly name="order[invoice_date]" type="text"
                                    value="<?php echo e($order->invoice_date ?: old('order')['invoice_date'] ?? date('Y-m-d')); ?>"
                                    <?php if($settings['enable_edit_date'] == 1): ?> id="datepicker" <?php endif; ?> class="form-control">
                            </div>
                            <!-- /.input group -->
                        </div>
                    </div>
                    <div class="<?php echo e($useMarket ? 'col-md-3' : 'col-md-4'); ?>">
                        <div class="form-group">
                            <?php
                                $salesMan = [];
                                $marktersMan = [];
                                if ($type == 'sales') {
                                    $title = trans('front.client');
                                    $defaultperson = \App\Person::whereIn('name', ['عميل نقدي', 'عميل كاش'])->first();
                                    $salesMan = \App\Employee::where('type', 'sales')->get();
                                    $marktersMan = \App\Employee::where('type', 'markter')->get();

                                    $userListRoute = route('person.getList', ['type' => 'client']);
                                    $route = route('client.create', ['req' => 'ajax']);
                                } else {
                                    $title = trans('front.supplier');
                                    $defaultperson = \App\Person::whereIn('name', ['مورد نقدي', 'مورد كاش'])->first();
                                    $userListRoute = route('person.getList', ['type' => 'supplier']);
                                    $route = route('supplier.create', ['req' => 'ajax']);
                                }
                                if (isset($order->invoice_number)) {
                                    $invoice_number = $order->invoice_number;
                                } else {
                                    $lastItem = \App\Order::where('invoice_type', $type)
                                        ->orderby('id', 'DESC')
                                        ->first();
                                    $invoice_number = $lastItem ? $lastItem->invoice_number + 1 : 1;
                                }
                            ?>
                            <label>
                                <?php echo e($title); ?> <span class="lastBalance" style="color: red"></span>
                            </label>

                            <div class="input-group">
                                <select data-ajax--url="<?php echo e($userListRoute); ?>" data-ajax--cache="true"
                                    data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>" id="personList" name="order[client_id]"
                                    required class="form-control select2">
                                    <option data-mobile="" value=""><?php echo app('translator')->getFromJson('front.select'); ?></option>
                                    <?php
                                        $per = \App\Person::find($order->client_id);
                                    ?>
                                    <?php if($order->client_id && $per): ?>

                                        <option points="<?php echo e($per->total_points); ?>"
                                            data-mobile="<?php echo e($per->mobile . ' ' . $per->mobile2); ?>"
                                            last_transaction="<?php echo e($per->last_transaction); ?>"
                                            priceType="<?php echo e($per->priceType); ?>" rel="<?php echo e($per->total_due); ?>" selected
                                            value="<?php echo e($per->id); ?>"><?php echo e($per->name); ?></option>
                                    <?php elseif(isset(old('order')['client_id']) && !empty(old('order')['client_id'])): ?>
                                        <?php
                                            $per = \App\Person::find(old('order')['client_id']);
                                        ?>
                                        <option points="<?php echo e($per->total_points); ?>"
                                            data-mobile="<?php echo e($per->mobile . ' ' . $per->mobile2); ?>"
                                            last_transaction="<?php echo e($per->last_transaction); ?>"
                                            priceType="<?php echo e($per->priceType); ?>" rel="<?php echo e($per->total_due); ?>" selected
                                            value="<?php echo e($per->id); ?>"><?php echo e($per->name); ?></option>
                                    <?php else: ?>
                                        <?php if($defaultperson): ?>
                                            <option points="<?php echo e($defaultperson->total_points); ?>"
                                                data-mobile="<?php echo e($defaultperson->mobile . ' ' . $defaultperson->mobile2); ?>"
                                                last_transaction="<?php echo e($defaultperson->last_transaction); ?>"
                                                priceType="<?php echo e($defaultperson->priceType); ?>"
                                                rel="<?php echo e($defaultperson->total_due); ?>" selected
                                                value="<?php echo e($defaultperson->id); ?>"><?php echo e($defaultperson->name); ?></option>
                                        <?php endif; ?>
                                    <?php endif; ?>
                                    
                                </select>
                                <div class="input-group-addon no-print" style="padding: 2px 5px;">
                                    <a href="<?php echo e($route); ?>" class="external" data-toggle="modal"
                                        data-target="#addPersonModal">
                                        <i class="fa fa-2x fa-plus-circle"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <input type="hidden" id="manager_id" name="order[manager_id]"
                        value="<?php echo e(optional($order->saleMan)->manager_id); ?>">
                    <div class="<?php echo e($type == 'sales' && $useMarket ? 'col-md-3' : 'col-md-4'); ?>">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.sale'); ?></label>
                            <select data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>" name="order[sale_id]"
                                class="form-control select2 salePersonSelect" style="width:100%;">
                                <option value=""></option>
                                <?php $__currentLoopData = $salesMan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option manager_id="<?php echo e($per->manager_id); ?>"
                                        <?php echo e($per->id == $order->sale_id ? 'selected' : ''); ?>

                                        value="<?php echo e($per->id); ?>">
                                        <?php echo e($per->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <?php if($type == 'sales' && $useMarket): ?>
                        <div class="col-md-3">
                            <div class="form-group">
                                <label><?php echo app('translator')->getFromJson('markter'); ?></label>
                                <select id="marketerSelect" data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>"
                                    name="order[markter_id]" class="form-control select2 ">
                                    <option value=""></option>
                                    <?php $__currentLoopData = $marktersMan; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $per): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option <?php echo e($per->id == $order->markter_id ? 'selected' : ''); ?>

                                            value="<?php echo e($per->id); ?>"><?php echo e($per->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                        </div>
                    <?php endif; ?>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.invoicenumber'); ?></label>
                            <div class="input-group date">
                                <div class="input-group-addon">
                                    <i class="fa  fa-pencil-square-o"></i>
                                </div>
                                <input readonly required name="order[invoice_number]" value="<?php echo e($invoice_number); ?>"
                                    type="number" class="form-control pull-right">
                            </div>
                        </div>
                    </div>
                    <?php if($type != 'sales'): ?>
                        <div class="col-md-4">
                            <div class="form-group">
                                <label>رقم فاتورة المورد</label>
                                <input name="order[supplier_invoice_number]"
                                    value="<?php echo e($order->supplier_invoice_number ?? ''); ?>" type="text"
                                    class="form-control pull-right">
                            </div>
                        </div>
                    <?php endif; ?>

                    <div class="col-md-4">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.status'); ?></label>
                            <select data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>" name="order[status]"
                                class="form-control select2 " style="width:100%;">
                                <option <?php echo e($order->status == 'delivered' ? 'selected' : ''); ?> value="delivered">
                                    <?php echo app('translator')->getFromJson('front.delivered'); ?></option>
                                <option <?php echo e($order->status == 'not-delivered' ? 'selected' : ''); ?>

                                    value="not-delivered">
                                    <?php echo app('translator')->getFromJson('front.not-delivered'); ?></option>
                            </select>
                        </div>
                    </div>
                    <div class="<?php echo e($type == 'sales' ? 'col-md-4' : 'hide'); ?>">
                        <div class="form-group">
                            <label><?php echo app('translator')->getFromJson('front.type'); ?></label>
                            <select id="priceType" name="order[priceType]" class="form-control">
                                <option value="one"><?php echo app('translator')->getFromJson('front.Sector price'); ?> </option>
                                <option value="half"><?php echo app('translator')->getFromJson('front.Half wholesale'); ?></option>
                                <option value="multi"><?php echo app('translator')->getFromJson('front.Wholesale price'); ?> </option>
                                <option value="gomla_gomla_price"><?php echo app('translator')->getFromJson('front.gomlaprice'); ?> </option>

                            </select>
                        </div>
                    </div>
                </div>
            </div>
            <!-- /.row -->

            <?php if($type == 'sales'): ?>
                <div class="col-md-12">
                    <div class="form-group">
                        <label>رقم الفاتورة الورقية</label>
                        <input name="order[supplier_invoice_number]"
                            value="<?php echo e($order->supplier_invoice_number ?? ''); ?>" type="text"
                            class="form-control pull-right">
                    </div>
                </div>
            <?php endif; ?>
            <div class="col-md-12">
                <div class="form-group">
                    <label><?php echo app('translator')->getFromJson('front.payment'); ?></label>
                    <select id="paymentMethod" data-placeholder="<?php echo app('translator')->getFromJson('front.select'); ?>" name="order[payment_type]"
                        class="form-control select2 " style="width:100%;">
                        <option
                            <?php echo e((isset(old('order')['payment_type']) && old('order')['payment_type'] == 'cash') || $order->payment_type == 'cash' || (empty($order->payment_type) && $settings['default_payment'] == 'cash') ? 'selected' : ''); ?>

                            value="cash"><?php echo app('translator')->getFromJson('front.cash'); ?></option>
                        <option
                            <?php echo e((isset(old('order')['payment_type']) && old('order')['payment_type'] == 'delayed') || $order->payment_type == 'delayed' || $order->getOriginal('due') > 0 || (empty($order->payment_type) && $settings['default_payment'] == 'delayed') ? 'selected' : ''); ?>

                            value="delayed"><?php echo app('translator')->getFromJson('front.Postpaid'); ?></option>
                        <option
                            <?php echo e((isset(old('order')['payment_type']) && old('order')['payment_type'] == 'visa') || $order->payment_type == 'visa' || (empty($order->payment_type) && $settings['default_payment'] == 'visa') ? 'selected' : ''); ?>

                            value="visa"><?php echo app('translator')->getFromJson('front.visa'); ?></option>
                        <option
                            <?php echo e((isset(old('order')['payment_type']) && old('order')['payment_type'] == 'link transfer') || $order->payment_type == 'link transfer' || (empty($order->payment_type) && $settings['default_payment'] == 'link transfer') ? 'selected' : ''); ?>

                            value="link transfer"><?php echo app('translator')->getFromJson('front.link transfer'); ?></option>
                        
                    </select>
                </div>
            </div>
            <div id="visaAuthCode" class="col-md-12 hide">
                <div class="form-group">
                    <label><?php echo app('translator')->getFromJson('front.Auth Code'); ?></label>
                    <input name="order[auth_code]" value="" class="form-control">
                </div>
            </div>
            <div id="invoiceProductList">
                <div class="col-md-2">
                    <div class="form-group">
                        <label for=""><?php echo app('translator')->getFromJson('front.store'); ?></label>
                        <select id="productStores" class="form-control storeList" required="required">
                            <?php $__currentLoopData = auth()->user()->stores; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($s->id); ?>"><?php echo e($s->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="<?php echo e($settings['show_category_in_invoice'] == 1 ? 'col-md-2' : 'hide'); ?>">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.parent'); ?></label>
                        <select id="category_id" class="form-control select2" style="width: 100%;">
                            <option value=""><?php echo app('translator')->getFromJson('front.all'); ?></option>
                            <?php $__currentLoopData = \App\Category::where('type', 1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                </div>
                <div class="<?php echo e($useMarket || $settings['show_category_in_invoice'] == 1 ? 'col-md-4' : 'col-md-5'); ?>">
                    <div class="form-group">
                        <label for=""><?php echo app('translator')->getFromJson('front.product'); ?></label>
                        <div class="input-group">
                            <input name="search_input" autocomplete="off"
                                class="typeahead form-control selectProduct" type="text">
                            <input type="hidden" value="" id="productID">
                            <input type="hidden" value="" id="productName">
                            <?php if($type == 'sales'): ?>
                                <?php if($settings['use_bounse'] == 1): ?>
                                    <span class="input-group-addon">
                                        <button type="button" data-toggle="modal"
                                            data-target="#modal-dicounts-bounse">
                                            <i class="fa fa-tags"></i>
                                        </button>
                                    </span>
                                <?php endif; ?>
                                <span class="input-group-addon btn hide">
                                    <input id="is_new" type="checkbox" class="minimal-red">
                                </span>
                                <span style="padding: 0 5px;" class="input-group-addon">
                                    
                                    <a href="<?php echo e(route('products.create', ['req' => 'ajax'])); ?>"
                                        class="addNewItem external" data-toggle="modal"
                                        data-target="#addPersonModal">
                                        <i class="fa fa-2x fa-plus-circle"></i>
                                    </a>
                                </span>
                            <?php else: ?>
                                <span class="input-group-addon btn hide">
                                    <input id="is_new" type="checkbox" class="minimal-red">
                                </span>
                                <span style="padding: 0 5px;" class="input-group-addon">
                                    
                                    <a href="<?php echo e(route('products.create', ['req' => 'ajax'])); ?>"
                                        class="addNewItem external" data-toggle="modal"
                                        data-target="#addPersonModal">
                                        <i class="fa fa-2x fa-plus-circle"></i>
                                    </a>
                                </span>
                            <?php endif; ?>
                            <i class="fa fa-circle-o-notch fa-spin loader hide"></i>

                            <span style="width: 100px;" class="unit input-group-addon">
                                <select id="unitList" class="form-control unitList" required>
                                    <?php $__currentLoopData = \App\Unit::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unit): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($unit->id); ?>"><?php echo e($unit->name); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </span>
                        </div>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <label for=""><?php echo app('translator')->getFromJson('front.saleprice'); ?></label>
                        <div class="input-group">
                            <?php
                                $isreadOnly = '';
                                if ($settings['canChangePrice'] == 2 && $type == 'sales') {
                                    if (
                                        auth()
                                            ->user()
                                            ->roles()
                                            ->first()->id != 1
                                    ) {
                                        $isreadOnly = 'readonly';
                                    }
                                }
                            ?>
                            <input type="hidden" id="customer_price" value="">
                            <input <?php echo e($isreadOnly); ?> id="unitPrice" autocomplete="off" class="form-control"
                                type="text">
                            <input id="unitCost" type="hidden">
                            <span style="color: #ffffff;" id="CostPriceSpan"
                                class="input-group-addon btn btn-info <?php echo e(auth()->user()->show_cost_price ? '' : 'hide'); ?>">
                            </span>
                        </div>
                    </div>
                </div>

                <div class="<?php echo e($settings['show_category_in_invoice'] == 1 ? 'col-md-2' : 'col-md-3'); ?>">
                    <div class="form-group">

                        <label><?php echo app('translator')->getFromJson('front.quantity'); ?></label>
                        <div class="input-group">

                            <input style=" min-width: 120px; " id="productQty" value="1" min="0"
                                step="0.001" type="number" type="text" class="form-control qty">
                            <span style="color:#ffffff;" id="unitQty" class="input-group-addon btn">
                                0
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12" id="markterratio">

            </div>
            <div style="overflow: auto;" class="col-md-8">
                <table class="table table-bordered table-responsive">
                    <thead>
                        <tr class="bg-primary">
                            <th>#</th>
                            <th><?php echo app('translator')->getFromJson('front.store'); ?></th>
                            <th class="col-md-4"><?php echo app('translator')->getFromJson('front.product'); ?></th>
                            <th>الموظف</th>
                            <th><?php echo app('translator')->getFromJson('front.quantity'); ?></th>
                            <th><?php echo app('translator')->getFromJson('front.saleprice'); ?></th>
                            <?php if($settings['industrial'] == 3): ?>
                                <th>الخصم</th>
                            <?php endif; ?>
                            
                            <th><?php echo app('translator')->getFromJson('front.unit'); ?></th>
                            <?php if($settings['use_bounse'] == 1): ?>
                                <th class="col-md-2"><?php echo app('translator')->getFromJson('front.bounse'); ?></th>
                            <?php endif; ?>

                            <th><?php echo app('translator')->getFromJson('front.total'); ?></th>
                            <?php if($type == 'sales' && $useMarket): ?>
                                <th><?php echo app('translator')->getFromJson('front.commission'); ?></th>
                            <?php endif; ?>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody id="invoiceTable">
                        <?php
                            $productsListIds = [];
                        ?>
                        <?php if($settings['industrial'] == 3): ?>
                            <?php echo $__env->make('orders._pharma', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
                        <?php else: ?>
                            <?php $__currentLoopData = $order->details; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $rowClass = 'rowelement' . $item->id . '_' . $item->pivot->store_id . '_' . $item->pivot->unit_id;
                                    $productsListIds[] = $item->id;
                                ?>
                                <tr class="<?php echo e($rowClass); ?> bg-success">
                                    <td>
                                        <input type="hidden" class="rowIndex" value="<?php echo e($loop->iteration); ?>">
                                        <input type="hidden" name="product[<?php echo e($loop->iteration); ?>][store_name]"
                                            value="<?php echo e($item->pivot->store_name); ?>">
                                        <input type="hidden" name="product[<?php echo e($loop->iteration); ?>][customer_price]"
                                            value="<?php echo e($item->pivot->customer_price); ?>">
                                        <input type="hidden" name="product[<?php echo e($loop->iteration); ?>][is_service]"
                                            value="<?php echo e($item->pivot->is_service); ?>">

                                        <input type="hidden" class="rowUnit_name"
                                            name="product[<?php echo e($loop->iteration); ?>][unit_name]"
                                            value="<?php echo e($item->pivot->unit_name); ?>">
                                        <input type="hidden" name="product[<?php echo e($loop->iteration); ?>][product_name]"
                                            value="<?php echo e($item->name); ?>">
                                        <input class="itemCost" type="hidden"
                                            name="product[<?php echo e($loop->iteration); ?>][cost]"
                                            value="<?php echo e($item->pivot->cost); ?>">
                                        <?php echo e($loop->iteration); ?>

                                        <a href="#" class="switchStatus">
                                            <img style="width: 20px;" class="stateIcon"
                                                src="<?php echo e($item->pivot->status ? asset('icons/yes.png') : asset('icons/no.png')); ?>" />
                                            <input class="stateValue" type="hidden"
                                                value="<?php echo e($item->pivot->status); ?>"
                                                name="product[<?php echo e($loop->iteration); ?>][status]" />
                                        </a>
                                    </td>
                                    <td><input type="hidden" name="product[<?php echo e($loop->iteration); ?>][store_id]"
                                            value="<?php echo e($item->pivot->store_id); ?>"><?php echo e($item->pivot->store_name); ?></td>
                                    <td><input type="hidden" name="product[<?php echo e($loop->iteration); ?>][product_id]"
                                            value="<?php echo e($item->id); ?>"><?php echo e($item->name); ?></td>
                                    <td>
                                        <select class="form-control empList" name="product[<?php echo e($loop->iteration); ?>][employee_id]">
                                            <option value="">بدون</option>
                                            <?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $id => $name): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option <?php echo e($item->pivot->employee_id==$id?'selected':''); ?> value="<?php echo e($id); ?>"><?php echo e($name); ?>

                                                </option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </td>
                                    <td><input class="itemQty tdinput" type="text"
                                            name="product[<?php echo e($loop->iteration); ?>][qty]"
                                            value="<?php echo e($item->pivot->qty - $item->pivot->return_qty); ?>"></td>
                                    <td><input class="itemPrice tdinput" type="text"
                                            name="product[<?php echo e($loop->iteration); ?>][price]"
                                            value="<?php echo e($item->pivot->price); ?>"></td>
                                    <?php if($settings['industrial'] == 3): ?>
                                        <td>
                                            <table>
                                                <tr>
                                                    <td>
                                                        <input class="itemdiscount1 tdinput" type="text"
                                                            name="product[<?php echo e($loop->iteration); ?>][discount1]"
                                                            value="<?php echo e($item->pivot->discount1 ?? 20); ?>">
                                                    </td>
                                                    <td>
                                                        <input class="itemdiscount2 tdinput" type="text"
                                                            name="product[<?php echo e($loop->iteration); ?>][discount1]"
                                                            value="<?php echo e($item->pivot->discount2 ?? 5); ?>">
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    <?php endif; ?>
                                    
                                    <td><input type="hidden" name="product[<?php echo e($loop->iteration); ?>][unit_id]"
                                            value="<?php echo e($item->pivot->unit_id); ?>"><?php echo e($item->pivot->unit_name); ?></td>
                                    <?php if($settings['use_bounse'] == 1): ?>
                                        <td>
                                            <input type="hidden" name="product[<?php echo e($loop->iteration); ?>][bounse]"
                                                value="<?php echo e($item->pivot->bounse); ?>">
                                            <input type="hidden"
                                                name="product[<?php echo e($loop->iteration); ?>][bounse_unit_id]"
                                                value="<?php echo e($item->pivot->bounse_unit_id); ?>">
                                            <input type="hidden"
                                                name="product[<?php echo e($loop->iteration); ?>][bounseUnitText]"
                                                value="<?php echo e($item->pivot->bounseUnitText); ?>">
                                            <?php echo e($item->pivot->bounse); ?> <?php echo e($item->pivot->bounseUnitText); ?>

                                        </td>
                                    <?php endif; ?>
                                    <td>
                                        <input class="itemTotal tdinput" readonly type="text"
                                            name="product[<?php echo e($loop->iteration); ?>][total]"
                                            value="<?php echo e(($item->pivot->qty - $item->pivot->return_qty) * $item->pivot->price); ?>">
                                    </td>
                                    <?php if($type == 'sales' && $useMarket): ?>
                                        <td>
                                            <input type="hidden" name="product[<?php echo e($loop->iteration); ?>][markter]"
                                                value="<?php echo e($item->pivot->markter); ?>">
                                            <?php echo e($item->pivot->markter); ?>

                                        </td>
                                    <?php endif; ?>
                                    <td><a href="#" class="btn btn-sm btn-danger"><i
                                                class="fa fa-trash"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                            <?php if(old('product')): ?>
                                <?php $__currentLoopData = old('product'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $oldProd): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        if (!isset($oldProd['product_id'])) {
                                            continue;
                                        }

                                        $rowClass = 'rowelement' . $oldProd['product_id'] . '_' . $oldProd['store_id'] . '_' . $oldProd['unit_id'];
                                    ?>
                                    <?php if(empty($productsListIds) || (!empty($productsListIds) && !in_array($oldProd['product_id'], $productsListIds))): ?>
                                        {
                                        <tr class="<?php echo e($rowClass); ?> bg-success">
                                            <td>
                                                <input type="hidden" class="rowIndex"
                                                    value="<?php echo e($loop->iteration); ?>">
                                                <input type="hidden"
                                                    name="product[<?php echo e($loop->iteration); ?>][store_name]"
                                                    value="<?php echo e($oldProd['store_name']); ?>">
                                                <input type="hidden"
                                                    name="product[<?php echo e($loop->iteration); ?>][customer_price]"
                                                    value="<?php echo e($oldProd['customer_price']); ?>">
                                                <input type="hidden"
                                                    name="product[<?php echo e($loop->iteration); ?>][is_service]"
                                                    value="<?php echo e($oldProd['is_service']); ?>">

                                                <input type="hidden" class="rowUnit_name"
                                                    name="product[<?php echo e($loop->iteration); ?>][unit_name]"
                                                    value="<?php echo e($oldProd['unit_name']); ?>">
                                                <input type="hidden"
                                                    name="product[<?php echo e($loop->iteration); ?>][product_name]"
                                                    value="<?php echo e($oldProd['product_name']); ?>">
                                                <input class="itemCost" type="hidden"
                                                    name="product[<?php echo e($loop->iteration); ?>][cost]"
                                                    value="<?php echo e($oldProd['cost']); ?>">
                                                <?php echo e($loop->iteration); ?>

                                            </td>
                                            <td><input type="hidden"
                                                    name="product[<?php echo e($loop->iteration); ?>][store_id]"
                                                    value="<?php echo e($oldProd['store_id']); ?>"><?php echo e($oldProd['store_name']); ?>

                                            </td>
                                            <td><input type="hidden"
                                                    name="product[<?php echo e($loop->iteration); ?>][product_id]"
                                                    value="<?php echo e($oldProd['product_id']); ?>"><?php echo e($oldProd['product_name']); ?>

                                            </td>
                                            <td><input class="itemQty tdinput" type="text"
                                                    name="product[<?php echo e($loop->iteration); ?>][qty]"
                                                    value="<?php echo e($oldProd['qty']); ?>"></td>
                                            <td><input class="itemPrice tdinput" type="text"
                                                    name="product[<?php echo e($loop->iteration); ?>][price]"
                                                    value="<?php echo e($oldProd['price']); ?>"></td>
                                            
                                            <td><input type="hidden"
                                                    name="product[<?php echo e($loop->iteration); ?>][unit_id]"
                                                    value="<?php echo e($oldProd['unit_id']); ?>"><?php echo e($oldProd['unit_name']); ?>

                                            </td>
                                            <?php if($settings['use_bounse'] == 1): ?>
                                                <td>
                                                    <input type="hidden"
                                                        name="product[<?php echo e($loop->iteration); ?>][bounse]"
                                                        value="<?php echo e($oldProd['bounse']); ?>">
                                                    <input type="hidden"
                                                        name="product[<?php echo e($loop->iteration); ?>][bounse_unit_id]"
                                                        value="<?php echo e($oldProd['bounse_unit_id']); ?>">
                                                    <input type="hidden"
                                                        name="product[<?php echo e($loop->iteration); ?>][bounseUnitText]"
                                                        value="<?php echo e($oldProd['bounseUnitText']); ?>">
                                                    <?php echo e($oldProd['bounse']); ?> <?php echo e($oldProd['bounseUnitText']); ?>

                                                </td>
                                            <?php endif; ?>
                                            <td>
                                                <input class="itemTotal tdinput" readonly type="text"
                                                    name="product[<?php echo e($loop->iteration); ?>][total]"
                                                    value="<?php echo e($oldProd['total']); ?>">
                                            </td>
                                            <?php if($type == 'sales' && $useMarket): ?>
                                                <td>
                                                    <input type="hidden"
                                                        name="product[<?php echo e($loop->iteration); ?>][markter]"
                                                        value="">
                                                </td>
                                            <?php endif; ?>
                                            <td><a href="#" class="btn btn-sm btn-danger"><i
                                                        class="fa fa-trash"></i></a></td>
                                        </tr>
                                    <?php endif; ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>

                        <?php endif; ?>
                    </tbody>
                </table>
                <?php if(env('turbo_authentication_key')): ?>
                    <div class="col-md-12">
                        <div class="form-group">
                            <label>تكلفة الشحن</label>
                            <input type="number" name="order[shipment_amount]" class="form-control"
                                value="<?php echo e($order->shipment_amount ?? 0); ?>" />
                        </div>
                    </div>
                <?php endif; ?>
                <div class="col-md-12">
                    <div class="form-group">
                        <label><?php echo app('translator')->getFromJson('front.Notes on the invoice'); ?></label>
                        <textarea name="order[note]" class="form-control"><?php echo e($order->note); ?></textarea>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <table class="table table-bordered pull-right">
                    <tr>
                        <td style="vertical-align: middle;"><?php echo app('translator')->getFromJson('front.total'); ?>:-</td>
                        <td>
                            <input readonly id="total" value="<?php echo e($order->fgrand_order_total); ?>"
                                class="form-control">
                        </td>
                    </tr>
                    <tr>
                        <td style="vertical-align: middle;"><?php echo app('translator')->getFromJson('front.discount'); ?>:-
                            <span class="input-group-addon ">
                                <input id="discount_type" value="1" name="order[discount_type]"
                                    <?php if($order->discount_type == 2 || (isset(old('order')['discount_type']) && old('order')['discount_type'] == 2)): ?> checked <?php endif; ?> type="checkbox"
                                    class="flat-red ">
                                %
                            </span>
                        </td>
                        <td>
                            <div class="input-group">
                                <input type="number" step="0.01" required id="discount" name="order[discount]"
                                    value="<?php echo e(old('order')['discount'] ?? ($order->discount ?? 0)); ?>"
                                    class="form-control">
                                <input type="hidden" name="order[discount_value]"
                                    value="<?php echo e(old('order')['discount_value'] ?? ($order->discount_value ?? 0)); ?>">
                                <span style="color:#ffffff;" id="disValue" class="input-group-addon btn ">

                                </span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="vertical-align: middle;"><?php echo app('translator')->getFromJson('front.tax'); ?>:-</td>
                        <td>
                            <div class="input-group">
                                <input id="TaxValue" name="order[tax_value]"
                                    value="<?php echo e(old('order')['tax_value'] ?? ($order->tax_value ?? 0)); ?>"
                                    class="hide">
                                <input id="tax" name="order[tax]"
                                    value="<?php echo e(old('order')['tax'] ?? ($order->tax ?? $settings['taxValue'])); ?>"
                                    class="form-control">
                                <span class="input-group-addon btn">
                                    %
                                </span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="vertical-align: middle;">الصافـــي:-</td>
                        <td>
                            <input readonly id="totalafter" value="<?php echo e($order->total); ?>" name="order[total]"
                                value="0" class="form-control">
                        </td>
                    </tr>
                    <?php if($type == 'sales' && $settings['point_value']): ?>
                        <tr>
                            <td><?php echo app('translator')->getFromJson('front.point'); ?></td>
                            <td>
                                <input name="order[use_point]" <?php if($order->use_point == 1): ?> checked <?php endif; ?>
                                    type="checkbox" class="flat-red use_pointInput">
                                <span class="userpointSpan hide">0</span>
                            </td>
                        </tr>
                    <?php endif; ?>
                    <tr>
                        <td style="vertical-align: middle;"><?php echo app('translator')->getFromJson('front.paid'); ?>:-</td>
                        <td>
                            <input type="number" step="0.01" required id="paid" name="order[paid]"
                                value="<?php echo e(old('order')['paid'] ?? ($order->paid ?? 0)); ?>" class="form-control" />
                        </td>
                    </tr>
                    <tr>
                        <td style="vertical-align: middle;"><?php echo app('translator')->getFromJson('front.due'); ?>:-</td>
                        <td>
                            <div class="input-group">
                                <input readonly required id="due" name="order[due]"
                                    value="<?php echo e($order->due ?? (old('order')['due'] ?? 0)); ?>" class="form-control" />
                                <span class="input-group-addon">

                                    <button class="<?php echo e(count($order->calander) ? 'bg-yellow' : ''); ?>" type="button"
                                        data-toggle="modal" data-target="#modal-calander">
                                        <i class="fa fa-calendar"></i>
                                    </button>
                                </span>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <td style="vertical-align: middle;"><?php echo app('translator')->getFromJson('front.before'); ?>:-</td>
                        <td>
                            <input readonly required id="lastBalance"
                                value="<?php echo e($order->id ? round($order->client->total_due - $order->due, 1) : 0); ?>"
                                class="form-control">
                        </td>
                    </tr>
                    <tr class="<?php echo e($order->id ? 'hide' : ''); ?>">
                        <td style="vertical-align: middle;"><?php echo app('translator')->getFromJson('front.balance'); ?>:-</td>
                        <td>
                            <input readonly required id="totalBalance"
                                value="<?php echo e(round(optional($order->client)->total_due, 1)); ?>" class="form-control">
                        </td>
                    </tr>
                    <?php if(!$order->id): ?>
                        <tr>
                            <td style="vertical-align: middle;"><?php echo app('translator')->getFromJson('front.Last payment'); ?>:-</td>
                            <td id="last_transaction" class="bg-yellow">
                            </td>
                        </tr>
                    <?php endif; ?>
                    <?php if($type == 'sales'): ?>
                        <tr>
                            <td><?php echo app('translator')->getFromJson('front.Withdrawals'); ?></td>
                            <td><input class="flat-red" name="is_withdrawable" type="checkbox"
                                    <?php if(request()->has('withdraw') || $order->is_withdrawable): ?> checked <?php endif; ?>></td>
                        </tr>
                    <?php endif; ?>
                </table>
            </div>
        </div>
        <div class="modal  fade" id="modal-calander" tabindex="-1">
            <div class="modal-dialog">
                <div class="modal-content">
                    <div class="modal-header">
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span></button>
                        <h4 class="modal-title">الدفعات</h4>
                    </div>
                    <div class="modal-body calanderList">
                        <div class="row">
                            <div class="col-md-12" style="text-align: left">
                                <input id="QestNumInput" type="number" name="count" value=""
                                    placeholder="اكتب عدد الأقساط">
                                <a id="totalQest" style=" margin: 5px 22px; " class="btn btn-sm bg-warning">إجمالى
                                    القسط: 0</a>
                                <a id="QestCount" class="btn btn-sm bg-warning">عدد الأقساط : 0</a>
                                <a style=" margin: 15px 12px; "
                                    class="btn btn-sm bg-green addCalander paymentdueClander" href="#"><i
                                        class="fa fa-plus-square"></i></a>
                            </div>
                        </div>
                        <?php if($order->calander): ?>
                            <?php $__currentLoopData = $order->calander; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $calander): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="row itemCalnader">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>التاريخ</label>
                                            <div class="input-group date">
                                                <div class="input-group-addon">
                                                    <i class="fa fa-calendar"></i>
                                                </div>
                                                <input name="duepayment[date][]" type="text"
                                                    value="<?php echo e($calander->date); ?>"
                                                    class="form-control pull-right datepicker">
                                            </div>
                                            <!-- /.input group -->
                                        </div>
                                    </div>
                                    <div class="col-md-5">
                                        <div class="form-group">
                                            <label>المبلغ</label>
                                            <input name="duepayment[value][]" type="number"
                                                value="<?php echo e($calander->value); ?>" class="form-control pull-right">
                                        </div>
                                    </div>
                                    <div class="col-md-1">
                                        <a class="btn btn-sm bg-red removeCalander paymentdueClander"
                                            href="#"><i class="fa fa-minus-square"></i></a>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-primary save-calander pull-left">حفظ</button>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            <!-- /.modal-dialog -->
        </div>
        <!-- /.box-body -->
        <div class="box-footer"
            style="position: absolute;top: -55px;background: none;<?php echo e(\Session::get('locale') == 'ar' ? 'left: 15px;' : 'right:15px;'); ?>">
            <?php if(auth()->user()->can('profit HomeController') &&
                    ($settings['show_profit_button'] == 1 ||
                        auth()->user()->roles()->first()->id == 1)): ?>
                <a data-toggle="modal" href="#"
                    class="<?php echo e($type == 'sales' ? '' : 'hide'); ?> btn btn-warning profit"><i class="fa fa-chart"></i>
                    <?php echo app('translator')->getFromJson('front.profit'); ?></a>
            <?php endif; ?>
            <a id="salesDept" class="btn btn-info hide" href="#"></a>
            <button type="submit" class="btn btn-primary "><i class="fa fa-save"></i> <?php echo app('translator')->getFromJson('front.save'); ?> </button>
            <button type="submit" class="btn btn-success saveandPrint"><i class="fa fa-print"></i>
                <?php echo app('translator')->getFromJson('front.save and print'); ?> </button>
            <?php if($type != 'sales'): ?>
                <button type="submit" class="btn btn-primary saveandPrintBarcode"><i class="fa fa-barcode"></i> حفظ
                    وطباعة باركود </button>
            <?php endif; ?>
        </div>
    </div>
</section>
<?php if(!isset($notModal)): ?>
    <?php echo $__env->make('orders.js', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
<?php endif; ?>
<style>
    input.tdinput:focus {
        background-color: #fff !important;
    }

    input.tdinput {
        display: block;
        width: 100%;
        height: 28px;
        padding: 0;
        font-size: 14px;
        line-height: 1.42857143;
        color: #555;
        background-color: #dff0d8;
        border: 0px solid #fff;
        border-radius: 4px;
        border: 0px solid #fff !important;
        text-align: center;
    }
</style>
