<?php $__env->startSection('title','المصروفات'); ?>
<?php $__env->startSection('content'); ?>
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
			<?php echo app('translator')->getFromJson('front.expenses'); ?>
			<a data-toggle="modal" data-target="#myModal" class="btn btn-success pull-right" href="<?php echo e(route('expenses.create')); ?>" ><i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('front.Add'); ?></a>
		</h1>
	</section>

	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
                <?php echo $__env->make('layouts.partial.filter', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
				
				<!-- /.box-header -->
					<div class="box-body">

						<table id="dataList" class="table table-bordered table-striped">
							<thead>
							<tr>
								<th>#</th>
								<th><?php echo app('translator')->getFromJson('front.title'); ?></th>
                                <th>المجموعه</th>
								<th>قبل الضريبة</th>
								<th>قيمة الضريبة</th>
								<th>بعد الضريبة</th>
								<th>نوع المصروف</th>
								<th>التاريخ</th>
								<th class="no-sort"></th>
							</tr>
							</thead>
							<tbody>
							<?php $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $exp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e($exp->note); ?></td>
                                    <td><?php echo e(optional($exp->type)->name); ?></td>
									<td><?php echo e(currency($exp->value_before_tax,"EGP","EGP", $format = true)); ?></td>
									<td><?php echo e(currency($exp->tax_value,"EGP","EGP", $format = true)); ?></td>
									<td><?php echo e(currency($exp->value,"EGP","EGP", $format = true)); ?></td>
									<td><?php echo e($exp->partner_id?optional($exp->partner)->name:(($exp->employee_id)?optional($exp->employee)->name:'مصروف عام')); ?></td>
									<td><?php echo e($exp->created_at->format('Y-m-d')); ?></td>
									<td class="actions">
										<a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('expenses.edit',$exp)); ?>" class="btn btn-primary btn-xs">
											<i class="fa fa-pencil fa-fw" aria-hidden="true"></i>
											<?php echo app('translator')->getFromJson('front.edit'); ?>
										</a>
										<a class="btn btn-xs btn-danger remove-record" data-toggle="modal" data-url="<?php echo e(route('expenses.destroy',$exp)); ?>" data-id="<?php echo e($exp->id); ?>" data-target="#custom-width-modal">
											<i class="fa fa-trash"></i>
											<?php echo app('translator')->getFromJson('front.delete'); ?>
										</a>

									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->

	<div id="myModal" class="modal fade" style="overflow:hidden;" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title"></h4>
				</div>
				<div class="modal-body">
					<p class="text-center"><div class="fa-3x text-center"><i class="fa fa-cog fa-spin"></i>                    <?php echo app('translator')->getFromJson('front.Loading ....'); ?>                </div>                </p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-outline pull-left" data-dismiss="modal">إغلاق</button>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>