<?php $__env->startSection('title',trans('front.empTitle')); ?>
<?php $__env->startSection('content'); ?>
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
			<?php echo app('translator')->getFromJson('front.employees'); ?>
			<a data-toggle="modal" data-target="#myModal" class="btn btn-success pull-right" href="<?php echo e(route('employees.create')); ?>" ><i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('front.Add'); ?></a>
		</h1>
	</section>

	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
				
				<!-- /.box-header -->
					<div class="box-body">
						<table id="dataList" class="table table-bordered table-striped">
							<thead>
							<tr>
								<th>#</th>
								<th><?php echo app('translator')->getFromJson('front.name'); ?></th>
								<th><?php echo app('translator')->getFromJson('front.type'); ?></th>
								<th><?php echo app('translator')->getFromJson('front.telephone'); ?></th>
								<th class="no-sort"></th>
							</tr>
							</thead>
							<tbody>
							<?php $__currentLoopData = $employees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $emp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($loop->iteration); ?></td>
									<td><?php echo e($emp->name); ?></td>
									<td>
                                        <?php echo app('translator')->getFromJson("app.$emp->type"); ?>
                                        <?php if($emp->type=='sales'): ?>
                                            <br>
                                            <h6 class="text-bold bg-danger"><?php echo e(optional($emp->manger)->name); ?></h6>
                                        <?php endif; ?>
                                    </td>
									<td><?php echo e($emp->mobile); ?></td>
									<td class="actions">
										<a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('employees.edit',$emp)); ?>" class="btn btn-primary btn-xs">
											<i class="fa fa-pencil fa-fw" aria-hidden="true"></i>
											<?php echo app('translator')->getFromJson('front.edit'); ?>
										</a>
										<a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('employees.addPunishmentsRewards',$emp)); ?>" class="btn btn-warning btn-xs">
											<i class="fa fa-money" aria-hidden="true"></i>
											<?php echo app('translator')->getFromJson('front.Reward or punishment'); ?>
										</a>
										<a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('expenses.create',['employee_id'=>$emp])); ?>" class="btn btn-success btn-xs">
											<i class="fa fa-dollar" aria-hidden="true"></i>
											<?php echo app('translator')->getFromJson('front.Salary and advances'); ?>
										</a>
										<a href="<?php echo e(route('employees.show',$emp)); ?>" class="btn btn-info btn-xs">
											<i class="fa fa-eye" aria-hidden="true"></i>
											<?php echo app('translator')->getFromJson('front.show'); ?>
										</a>
										<a title="<?php echo app('translator')->getFromJson('front.delete'); ?>" class="btn btn-xs btn-danger remove-record" data-toggle="modal" data-url="<?php echo e(route('employees.destroy',$emp)); ?>" data-id="<?php echo e($emp->id); ?>" data-target="#custom-width-modal">
											<i class="fa fa-trash"></i>
										</a>

									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->

	<div id="myModal" class="modal fade" style="overflow:hidden;" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title"></h4>
				</div>
				<div class="modal-body">
					<p class="text-center"><div class="fa-3x text-center"><i class="fa fa-cog fa-spin"></i>                    <?php echo app('translator')->getFromJson('front.Loading ....'); ?>                </div>                </p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-outline pull-left" data-dismiss="modal">إغلاق</button>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>