<?php $__env->startSection('title',trans('front.users')); ?>
<?php $__env->startSection('content'); ?>
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
			<?php echo app('translator')->getFromJson('front.users'); ?>
            <?php if(auth()->user()->can('create UsersController')): ?>
			    <a data-toggle="modal" data-target="#myModal" class="btn btn-success pull-right" href="<?php echo e(route('users.create')); ?>" ><i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('front.Add'); ?></a>
            <?php endif; ?>
        </h1>
	</section>

	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
				
				<!-- /.box-header -->
					<div class="box-body">
						<table id="dataList" class="table table-bordered table-striped">
							<thead>
							<tr>
								<td>#</td>
								<th><?php echo app('translator')->getFromJson('front.name'); ?></th>
								<th><?php echo app('translator')->getFromJson('front.role'); ?></th>
								<th class="no-sort"></th>
							</tr>
							</thead>
							<tbody>
							<?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($loop->iteration); ?></td>
									<td><?php echo e($user->name); ?></td>
									<td><?php echo e(optional($user->roles()->first())->display_name); ?></td>
									<td class="actions">
                                        <?php if(auth()->user()->can('edit UsersController')): ?>
										<a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('users.edit',$user)); ?>" class="btn btn-primary btn-xs">
											<i class="fa fa-pencil fa-fw" aria-hidden="true"></i>
											<?php echo app('translator')->getFromJson('front.edit'); ?>
										</a>
                                        <?php endif; ?>
                                        <?php if(!$loop->first): ?>
                                            <?php if(auth()->user()->can('destroy UsersController')): ?>
                                            <a class="btn btn-xs btn-danger remove-record"  data-url="<?php echo e(route('users.destroy',$user)); ?>" data-id="<?php echo e($user->id); ?>">
                                                <i class="fa fa-trash"></i>
                                                <?php echo app('translator')->getFromJson('front.delete'); ?>
                                            </a>
                                            <?php endif; ?>
                                        <?php endif; ?>

									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->
	<!-- Delete Model -->
	<div id="myModal" class="modal fade" style="overflow:hidden;" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title"></h4>
				</div>
				<div class="modal-body">
					<p class="text-center"><div class="fa-3x text-center"><i class="fa fa-cog fa-spin"></i>                    <?php echo app('translator')->getFromJson('front.Loading ....'); ?>                </div>                </p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-outline pull-left" data-dismiss="modal">إغلاق</button>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>