<html>

<head>
    <link rel="stylesheet" href="{{asset('front/bootstrap')}}/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{ asset('front/jsSchedule.min.css') }}" />
    <style>
        body {
            padding-top: 60px;
            /* 60px to make the container go all the way to the bottom of the topbar */
        }

        #logs {
            border: solid 1px #bbb;
            padding: 16px;
            background: #eee;
        }

        #logs .table {
            margin-bottom: 0;
        }

        #logs .table td,
        #logs .table th {
            border: none;
        }

        #schedule .sc_bar_insert {
            background-color: #ff678a;
        }

        #schedule .example2 {
            background-color: #3eb698;
        }

        #schedule .example3 {
            color: #2c0000;
            font-weight: bold;
            background-color: #c7ae50;
        }

        #schedule .sc_bar.sc_bar_photo .head,
        #schedule .sc_bar.sc_bar_photo .text {
            padding-left: 60px;
        }

        #schedule .sc_bar.sc_bar_photo .photo {
            position: absolute;
            left: 10px;
            top: 10px;
            width: 38px;
        }

        #schedule .sc_bar.sc_bar_photo .photo img {
            max-width: 100%;
        }

        .jq-schedule .sc_menu .sc_header .sc_time {
            font-weight: bold;
        }

        .jq-schedule .sc_menu .sc_header_cell,
        .jq-schedule .sc_data {
            float: left;
            text-align: center;
            font-weight: bold;
        }
    </style>
</head>

<body>

    <div class="container">
        <div style="padding: 0 0 40px;">
            <div id="schedule"></div>
            {{-- <div class="row">
                <div class="col-md-8">
                    <h3>Log</h3>
                </div>
                <div class="col-md-4 text-right">
                    <a class="btn btn-default" style="margin-top: 16px;" id="clear-logs">clear</a>
                </div>

                <div class="col-md-12" style="padding: 12px 0 0;">
                    <div id="logs" class="table-responsive"></div>
                </div>
            </div> --}}
        </div>
    </div>
    <div rel="flipInX" id="myModal" class="modal fade">
        <div class="modal-dialog">
            <div class="modal-content">
                <div id="modalBody" class="modal-body"></div>
            </div>
        </div>
    </div>
    <script src="{{ asset('front/plugins') }}/jQuery/jquery-2.2.3.min.js"></script>
    <script src="{{ asset('front/dist/js') }}/jquery-ui.min.js" type="text/javascript" language="javascript"></script>
    <!-- Latest compiled and minified JavaScript -->
    <script src="{{ asset('front/bootstrap') }}/js/bootstrap.min.js" crossorigin="anonymous"></script>

    <script type="text/javascript" src="{{ asset('front') }}/plugins/jq.schedule.min.js"></script>
    <script type="text/javascript">
        var scheduleRows = @json($scheduleRows);

        function addLog(type, message) {
            // return false;
            // var $log = $('<tr />');
            // $log.append($('<th />').text(type));
            // $log.append($('<td />').text(message ? JSON.stringify(message) : ''));
            // $("#logs table").prepend($log);
        }
        $(function() {
            $("#logs").append('<table class="table">');
            var isDraggable = false;
            var isResizable = false;
            var $sc = $("#schedule").timeSchedule({
                startTime: "07:00", // schedule start time(HH:ii)
                endTime: "21:00", // schedule end time(HH:ii)
                widthTime: 60 * 10, // cell timestamp example 10 minutes
                timeLineY: 60, // height(px)
                verticalScrollbar: 20, // scrollbar (px)
                timeLineBorder: 2, // border(top and bottom)
                bundleMoveWidth: 6, // width to move all schedules to the right of the clicked time line cell
                draggable: isDraggable,
                resizable: isResizable,
                resizableLeft: true,
                rows: scheduleRows,
                onChange: function(node, data) {
                    addLog('onChange', data);
                },
                onInitRow: function(node, data) {
                    addLog('onInitRow', data);
                },
                onClick: function(node, data) {
                    //addLog('onClick', data);
                    $.ajax({
                        url: data.data.url,
                        method: 'get',
                        success: function(result) {
                            console.log('here');
                            //$('#modalTitle').html(event.title);
                            $('#myModal .modal-body').html(result);
                            $('#myModal').modal();
                        }
                    });
                },
                onAppendRow: function(node, data) {
                    addLog('onAppendRow', data);
                },
                onAppendSchedule: function(node, data) {
                    node.css('background-color', data.data.color);
                    addLog('onAppendSchedule', data);
                    if (data.data.class) {
                        node.addClass(data.data.class);
                    }
                    if (data.data.image) {
                        var $img = $('<div class="photo"><img></div>');
                        $img.find('img').attr('src', data.data.image);
                        node.prepend($img);
                        node.addClass('sc_bar_photo');
                    }
                },
                // onScheduleClick: function(node, time, timeline) {
                //     var start = time;
                //     var end = $(this).timeSchedule('formatTime', $(this).timeSchedule('calcStringTime',
                //         time) + 3600);
                //     $(this).timeSchedule('addSchedule', timeline, {
                //         start: start,
                //         end: end,
                //         text: 'Insert Schedule',
                //         data: {
                //             class: 'sc_bar_insert'
                //         }
                //     });
                //     addLog('onScheduleClick', time + ' ' + timeline);
                // },
            });
            $('#event_timelineData').on('click', function() {
                addLog('timelineData', $sc.timeSchedule('timelineData'));
            });
            $('#event_scheduleData').on('click', function() {
                addLog('scheduleData', $sc.timeSchedule('scheduleData'));
            });
            $('#event_resetData').on('click', function() {
                $sc.timeSchedule('resetData');

                addLog('resetData');
            });
            $('#event_resetRowData').on('click', function() {
                $sc.timeSchedule('resetRowData');
                addLog('resetRowData');
            });
            $('#event_setDraggable').on('click', function() {
                isDraggable = !isDraggable;
                $sc.timeSchedule('setDraggable', isDraggable);
                addLog('setDraggable', isDraggable ? 'enable' : 'disable');
            });
            $('#event_setResizable').on('click', function() {
                isResizable = !isResizable;
                $sc.timeSchedule('setResizable', isResizable);
                addLog('setResizable', isResizable ? 'enable' : 'disable');
            });
            $('.ajax-data').on('click', function() {
                $.ajax({
                        url: './data/' + $(this).attr('data-target')
                    })
                    .done((data) => {
                        addLog('Ajax GetData', data);
                        $sc.timeSchedule('setRows', data);
                    });
            });
            $('#clear-logs').on('click', function() {
                $('#logs .table').empty();
            });
        });
    </script>
</body>

</html>
