@extends('layouts.app')
@section('content')
    <section class="content-header">
        <h1>@lang('front.Cashier screen')</h1>
    </section>

    <!-- Main content -->
    <section class="content">
        <form action="{{ route('orders.store') }}" method="post">
            {{ csrf_field() }}
            <input type="hidden" name="ispos" value="1">
            <div class="hide">
                <div class="form-group">
                    <label>@lang('front.status')</label>
                    <select data-placeholder="@lang('front.select')" name="order[status]" class="form-control select2 "
                        style="width:100%;">
                        <option selected value="delivered">@lang('front.delivered')</option>
                        <option value="not-delivered">@lang('front.not-delivered')</option>
                    </select>
                </div>
            </div>
            <input id="savePrint" name="savePrint" value="" type="hidden">
            <div class="row">

                <div class="col-xs-12">
                    <div class="box box-primary">
                        <div class="box-body">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="">@lang('front.store')</label>
                                    <select id="productStores" class="form-control storeList" required="required">
                                        @foreach (auth()->user()->stores as $s)
                                            <option value="{{ $s->id }}">{{ $s->name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    @php
                                        $title = trans('front.client');
                                        $defaultperson = \App\Person::whereIn('name', [
                                            'عميل نقدي',
                                            'عميل كاش',
                                        ])->first();
                                        $salesMan = \App\Employee::where('type', 'sales')->get();
                                        $marktersMan = \App\Employee::where('type', 'markter')->get();
                                        $userListRoute = route('person.getList', ['type' => 'client']);
                                        $route = route('client.create', ['req' => 'ajax']);
                                    @endphp
                                    <label>
                                        @lang('front.client') <span class="lastBalance" style="color: red"></span>
                                    </label>
                                    <div class="input-group">
                                        <select data-ajax--url="{{ $userListRoute }}" data-ajax--cache="true"
                                            data-placeholder="@lang('front.select')" id="personList" name="order[client_id]"
                                            required class="form-control select2">
                                            <option data-mobile="" value="">@lang('front.select')</option>
                                            @if (isset(old('order')['client_id']) && !empty(old('order')['client_id']))
                                                @php
                                                    $per = \App\Person::find(old('order')['client_id']);
                                                @endphp
                                                <option points="{{ $per->total_points }}"
                                                    data-mobile="{{ $per->mobile . ' ' . $per->mobile2 }}"
                                                    last_transaction="{{ $per->last_transaction }}"
                                                    priceType="{{ $per->priceType }}" rel="{{ $per->total_due }}" selected
                                                    value="{{ $per->id }}">{{ $per->name }}</option>
                                            @else
                                                @if ($defaultperson)
                                                    <option points="{{ $defaultperson->total_points }}"
                                                        data-mobile="{{ $defaultperson->mobile . ' ' . $defaultperson->mobile2 }}"
                                                        last_transaction="{{ $defaultperson->last_transaction }}"
                                                        priceType="{{ $defaultperson->priceType }}"
                                                        rel="{{ $defaultperson->total_due }}" selected
                                                        value="{{ $defaultperson->id }}">{{ $defaultperson->name }}
                                                    </option>
                                                @endif
                                            @endif
                                        </select>
                                        <div class="input-group-addon no-print" style="padding: 2px 5px;">
                                            <a href="{{ $route }}" class="external" data-toggle="modal"
                                                data-target="#addPersonModal">
                                                <i class="fa fa-2x fa-plus-circle"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label>@lang('front.payment')</label>
                                    <select id="paymentMethod" data-placeholder="@lang('front.select')" name="order[payment_type]"
                                            class="form-control select2 " style="width:100%;">
                                        <option {{ $settings['default_payment'] == 'cash' ? 'selected' : '' }} value="cash">
                                            @lang('front.cash')
                                        </option>
                                        <option {{ $settings['default_payment'] == 'delayed' ? 'selected' : '' }} value="delayed">
                                            @lang('front.Postpaid')</option>
                                        <option value="visa">@lang('front.visa')</option>
                                        <option {{ $settings['default_payment'] == 'link transfer' ? 'selected' : '' }}
                                                value="link transfer">
                                            @lang('front.link transfer')</option>
                                        {{-- @foreach (\App\Bank::get() as $bank)
                                            <option balance="{{$bank->balance}}" {{$order->payment_type==$bank->name||empty($order->payment_type)?'selected':''}}  value="{{$bank->id}}">دفع نقدى{{" ( $bank->name ) "}}</option>
                                        @endforeach --}}
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">

                                <div class="nav-tabs-vertical">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <ul class="nav nav-tabs">
                                                <li class="header"><i class="fa fa-th"></i>
                                                    @lang('front.categories')</li>
                                                @foreach ($categories as $category)
                                                    <li @if ($loop->iteration == 1) class="active" @endif>
                                                        <a href="#tab-{{ $category->id }}"
                                                            data-toggle="tab">{{ $category->name }}</a>
                                                    </li>
                                                @endforeach

                                            </ul>
                                        </div>
                                        <div class="col-md-9">
                                            <div class="tab-content">
                                                @foreach ($categories as $category)
                                                    <div style="padding: 10px"
                                                        class="tab-pane {{ $loop->iteration == 1 ? 'active' : '' }}"
                                                        id="tab-{{ $category->id }}">
                                                        @foreach ($category->products->chunk(6) as $chunks)
                                                            <div class="row">
                                                                @foreach ($chunks as $item)
                                                                    <div class="col-md-2 posItem">
                                                                        <div class="image">
                                                                            <a class="addFirstUnit" href="#">
                                                                                <img
                                                                                    src="{{ optional($item->getFirstMedia('images'))->getUrl() ?: asset('icons/p.png') }}">
                                                                            </a>
                                                                        </div>
                                                                        <p class="prodname">
                                                                            {{ $item->name }}<br />
                                                                        </p>
                                                                        <div class="prices">
                                                                            @foreach ($item->productUnit as $unit)
                                                                                @php
                                                                                    $sale_price =
                                                                                        $unit->pivot->sale_price;
                                                                                @endphp
                                                                                <p>
                                                                                    <a unitname="{{ $unit->name }}"
                                                                                        prodname="{{ $item->name }}"
                                                                                        unit_id={{ $unit->id }}
                                                                                        href="#"
                                                                                        cost="{{ $unit->pivot->cost_price }}"
                                                                                        prodid="{{ $item->id }}"
                                                                                        prodprice="{{ $sale_price }}"
                                                                                        class="itemCard">
                                                                                        <span
                                                                                            class="label label-warning">{{ $unit->name }}:
                                                                                            {{ $sale_price }}
                                                                                            {{ currency()->getCurrency()['symbol'] ?? '' }}</span>
                                                                                    </a>
                                                                                </p>
                                                                            @endforeach
                                                                        </div>

                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        @endforeach

                                                        @foreach ($category->productsSubCategory->chunk(6) as $chunks)
                                                            <div class="row">
                                                                @foreach ($chunks as $item)
                                                                    <div class="col-md-2 posItem">
                                                                        <div class="image">
                                                                            <a class="addFirstUnit" href="#">
                                                                                <img
                                                                                    src="{{ optional($item->getFirstMedia('images'))->getUrl() ?: asset('icons/p.png') }}">
                                                                            </a>
                                                                        </div>
                                                                        <p class="prodname">
                                                                            {{ $item->name }}<br />
                                                                        </p>
                                                                        <div class="prices">
                                                                            @foreach ($item->productUnit as $unit)
                                                                                @php
                                                                                    $sale_price =
                                                                                        $unit->pivot->sale_price;
                                                                                @endphp
                                                                                <p>
                                                                                    <a unitname="{{ $unit->name }}"
                                                                                        prodname="{{ $item->name }}"
                                                                                        unit_id={{ $unit->id }}
                                                                                        href="#"
                                                                                        cost="{{ $unit->pivot->cost_price }}"
                                                                                        prodid="{{ $item->id }}"
                                                                                        prodprice="{{ $sale_price }}"
                                                                                        class="itemCard">
                                                                                        <span
                                                                                            class="label label-warning">{{ $unit->name }}:
                                                                                            {{ $sale_price }}
                                                                                            {{ currency()->getCurrency()['symbol'] ?? '' }}</span>
                                                                                    </a>
                                                                                </p>
                                                                            @endforeach
                                                                        </div>

                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                        @endforeach

                                                        @foreach ($category->productsservices->chunk(6) as $chunks)
                                                            <div class="row">
                                                                @foreach ($chunks as $item)
                                                                    @include('orders.item_card', [
                                                                        'col' => 2,
                                                                    ])
                                                                @endforeach
                                                            </div>
                                                        @endforeach

                                                        @foreach ($category->productsservicesSubCategory->chunk(6) as $chunks)
                                                            <div class="row">
                                                                @foreach ($chunks as $item)
                                                                    @include('orders.item_card', [
                                                                        'col' => 2,
                                                                    ])
                                                                @endforeach
                                                            </div>
                                                        @endforeach

                                                    </div>
                                                @endforeach
                                                <!-- /.tab-pane -->
                                            </div>
                                            <!-- /.tab-content -->
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-12">
                            <div class="box box-warning">
                                <div class="box-body">
                                    <table class="table table-bordered table-responsive">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>الخدمة</th>
                                                <th class="hide">الكمية</th>
                                                <th class="hide">الوحدة</th>
                                                <th>السعر</th>
                                                <th class="hide">الاجمالي</th>
                                                <th>ملحوظة</th>
                                                <th>الموظف</th>
                                                <th>التاريخ/الوقت</th>
                                                <th></th>
                                            </tr>
                                        </thead>
                                        <tbody id="invoiceTable">
                                        </tbody>
                                    </table>

                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xs-12">
                        <div class="box box-primary">
                            <div class="box-body">
                                <table class="table table-bordered pull-right">
                                    <tr>
                                        <td>
                                            <label>
                                                @lang('front.total'):-
                                            </label>
                                            <input readonly id="total" value="" value="0"
                                                class="form-control">
                                        </td>
                                        <td>
                                            <label>
                                                @lang('front.discount'):-
                                            </label>
                                            <div class="input-group">
                                                <input type="number" step="0.01" required id="discount"
                                                    name="order[discount]" value="0" class="form-control">
                                                <input type="hidden" name="order[discount_value]" value="0">

                                                <span class="input-group-addon ">
                                                    <input id="discount_type" value="1" name="order[discount_type]"
                                                        type="checkbox" class="flat-red ">
                                                    %
                                                </span>
                                                <span style="color:#ffffff;" id="disValue"
                                                    class="input-group-addon btn ">

                                                </span>
                                            </div>
                                        </td>
                                        <td>
                                            <label>
                                                @lang('front.tax'):-
                                            </label>
                                            <input id="TaxValue" name="order[tax_value]" value="0" class="hide">
                                            <div class="input-group">
                                                <input id="tax" name="order[tax]"
                                                    value="{{ $settings['taxValue'] ?? 0 }}" class="form-control">
                                                <span class="input-group-addon btn">
                                                    %
                                                </span>
                                            </div>
                                        </td>
                                        <td>
                                            <label>
                                                @lang('front.grand'):
                                            </label>
                                            <input readonly id="totalafter" value="" name="order[total]"
                                                value="0" class="form-control">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>
                                            <label>
                                                @lang('front.paid'):-
                                            </label>
                                            <input type="number" step="0.01" required id="paid"
                                                name="order[paid]" value="0" class="form-control" />
                                        </td>
                                        <td>
                                            <label>
                                                @lang('front.due'):-
                                            </label>
                                            <div class="input-group">
                                                <input readonly required id="due" name="order[due]" value="0"
                                                    class="form-control" />
                                            </div>
                                        </td>
                                        <td>
                                            <label>
                                                @lang('front.before'):-
                                            </label>
                                            <input readonly required id="lastBalance" value="0"
                                                class="form-control">
                                        </td>
                                        <td>
                                            <label>
                                                @lang('front.balance'):-
                                            </label>
                                            <input readonly required id="totalBalance" value=""
                                                class="form-control">
                                        </td>
                                    </tr>
                                    <tr>
                                        <td colspan="4">
                                            <button type="submit" class="btn btn-primary "><i class="fa fa-save"></i>
                                                @lang('front.save') </button>
                                            <button type="submit" class="btn btn-success saveandPrint"><i
                                                    class="fa fa-print"></i> @lang('front.save and print') </button>
                                        </td>
                                    </tr>
                                </table>
                            </div>
                        </div>
                    </div>

                </div>
        </form>
    </section>
@stop
@include('reservations._book_script')
