<?php $__env->startSection('title','تقرير الموظفين'); ?>
<?php $__env->startSection('content'); ?>
	<!-- Content Header (Page header) -->

	<section class="content-header">
		<h1>
			تقرير الموظفين
		</h1>
	</section>

	<!-- Main content -->
	<section class="content">
        <div class="row">
            <div class="col-lg-6 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-primary">
                    <div class="inner">
                        <h3 id="totalOrder"><?php echo e($totalResults->total_orders??0); ?></h3>
                        <p>عدد الفواتير</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-list-alt"></i>
                    </div>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-6 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?php echo e($totalResults->total_amount??0); ?></h3>
                        <p>إجمالى المبلغ</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
				 <div class="box-header">
                     <div class="row hideprint" style="margin-top: 10px;">
                         <div class="col-md-12">
                             <form action="" method="get">
                                 <div class="col-md-5">
                                     <div class="form-group ">
                                         <input id="fromdate" placeholder="<?php echo app('translator')->getFromJson('front.datefrom'); ?>" autocomplete="off" style="direction: rtl;" name="fromdate" value="<?php echo e(request()->fromdate); ?>" type="text" class="form-control datepicker">
                                     </div>
                                 </div>
                                 <div class="col-md-5">
                                     <div class="form-group">
                                         <input id="todate" placeholder="<?php echo app('translator')->getFromJson('front.dateto'); ?>" autocomplete="off" style="direction: rtl;" name="todate" value="<?php echo e(request()->todate); ?>" type="text" class="form-control datepicker">
                                     </div>
                                 </div>
                                 <div class="col-md-2">
                                     <button  type="submit" class="btn btn-primary form-control"><?php echo app('translator')->getFromJson('front.search'); ?></button>
                                 </div>
                             </form>
                         </div>
                     </div>
                 </div>
				<!-- /.box-header -->
					<div class="box-body">
						<table id="dataList" class="table table-bordered table-striped">
							<thead>
								<tr>
									<th>اسم الموظف</th>
									<th>عدد الفواتير</th>
                                    <th>إجمالي المبلغ</th>
								</tr>
							</thead>
                            <tbody>
                                <?php $__currentLoopData = $results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $result): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e(optional($result->employee)->name); ?></td>
                                        <td><?php echo e($result->total_orders); ?></td>
                                        <td><?php echo e($result->total_amount); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
						</table>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        $('.datepicker').datepicker({
            autoclose: true,
            rtl: true,
            format: 'yyyy-mm-dd',
            language: "<?php echo e(\Session::get('locale')); ?>",
        });
        $(".select2").select2({allowClear: true});
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>