<!-- Left side column. contains the logo and sidebar -->
<aside class="main-sidebar">
    <!-- sidebar: style can be found in sidebar.less -->
    <section class="sidebar">
        <!-- Sidebar user panel -->
        
        <!-- search form -->
        <form action="#" method="get" class="sidebar-form">
            <div class="input-group">
                <input autocomplete="off" type="text" name="q" class="form-control"
                    placeholder="<?php echo app('translator')->getFromJson('front.search'); ?>">
                <span class="input-group-btn">
                    <button type="submit" name="search" id="search-btn" class="btn btn-flat"><i
                            class="fa fa-search"></i>
                    </button>
                </span>
            </div>
        </form>
        <!-- /.search form -->
        <!-- sidebar menu: : style can be found in sidebar.less -->
        <ul class="sidebar-menu">
            <li class="header"><?php echo app('translator')->getFromJson('front.menu'); ?></li>
            <li id="homeLi"><a href="<?php echo e(route('home')); ?>"><i class="fa  fa-home"></i><span><?php echo app('translator')->getFromJson('front.home'); ?></span>
                </a></li>
            <?php if(auth()->user()->can('pos OrdersController')): ?>
                <li><a href="<?php echo e(route('pos')); ?>"><i class="fa fa-desktop"></i><span> <?php echo app('translator')->getFromJson('front.Cashier screen'); ?></span> </a></li>
            <?php endif; ?>

            <?php if(auth()->user()->can('index ReservationController')): ?>
                <li>
                    <a href="<?php echo e(route('reservations.index')); ?>">
                        <i class="fa fa-ticket"></i>
                        حجز موعد
                    </a>
                </li>
            <?php endif; ?>


            <?php if(auth()->user()->can('index ReservationController')): ?>

                <li class="treeview">
                    <a href="#">
                        <i class="fa fa-calendar"></i>
                        <span>المواعيد والحجز</span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        <?php if(auth()->user()->can('getBookings OrdersController')): ?>
                            <li>
                                <a href="<?php echo e(route('bookings.index')); ?>">
                                    <i class="fa fa-list"></i>
                                    كل الحجوزات
                                </a>
                            </li>
                            <li>
                                <a href="<?php echo e(route('reservations.index')); ?>">
                                    <i class="fa fa-plus-circle"></i>
                                    حجز موعد
                                </a>
                            </li>
                            <li><a href="<?php echo e(route('reservations.report')); ?>"><i class="fa fa-file"></i><span> تقرير
                                        الحجوزات</span> </a></li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>


            <?php if(auth()->user()->can('index ShipmentsController')): ?>
                <li><a href="<?php echo e(route('shipments.index')); ?>"><i class="fa fa-truck"></i><span>الشحنات</span> </a></li>
                <li><a href="<?php echo e(route('shipments.prepare')); ?>"><i class="fa fa-file"></i><span>تجهيز المحافظات</span>
                    </a></li>
                <li><a href="<?php echo e(route('shipments.report')); ?>?per_page=25&fromdate=<?php echo e(date('Y-m-d')); ?>"><i
                            class="fa fa-file"></i><span>تقرير الشحنات</span> </a></li>
            <?php endif; ?>
            <?php if(auth()->user()->can('index CombinationController')): ?>
                <li><a href="<?php echo e(route('combinations.index')); ?>"><i class="fa fa-dribbble"></i><span>مواصفات
                            الصنف</span>
                    </a></li>
            <?php endif; ?>
            <?php if(auth()->user()->can('index CompanyController')): ?>
                <li><a href="<?php echo e(route('companies.index')); ?>"><i class="fa fa-truck"></i><span>الشركات</span> </a></li>
            <?php endif; ?>
            <?php if(auth()->user()->can('getSales OrdersController')): ?>
                <li><a target="_blank" href="<?php echo e(route('order.create', ['notpopup' => 'yes'])); ?>"><i
                            class="fa  fa-calculator"></i><span><?php echo app('translator')->getFromJson('front.Separate POS'); ?></span> </a></li>
            <?php endif; ?>
            <?php if(auth()->user()->can('clientIndex PersonsController')): ?>
                <li><a href="<?php echo e(route('client.index')); ?>"><i class="fa fa-users"></i> <?php echo app('translator')->getFromJson('front.clients'); ?></a></li>
                <li><a href="<?php echo e(route('supplier.index')); ?>"><i class="fa fa-truck"></i><?php echo app('translator')->getFromJson('front.suppliers'); ?> </a></li>
            <?php endif; ?>
            <?php if(auth()->user()->can('create OrdersController')): ?>
                <li><a href="<?php echo e(route('order.create', ['notpopup' => 'yes'])); ?>"><i
                            class="fa  fa-calculator"></i><span><?php echo app('translator')->getFromJson('front.pos'); ?></span> </a></li>
            <?php endif; ?>
            <?php if(auth()->user()->can('getPurchases OrdersController')): ?>
                <li><a href="<?php echo e(route('purchase.create', ['notpopup' => 'yes'])); ?>"><i class="fa  fa-truck"></i><span>
                            نقطة شراء</span> </a></li>
            <?php endif; ?>
            <?php if($settings['industrial'] == 2): ?>
                <li><a href="<?php echo e(route('orders.workorders')); ?>"><i
                            class="fa fa-retweet"></i><span><?php echo app('translator')->getFromJson('front.workorders'); ?></span> </a></li>
            <?php endif; ?>
            <?php if(auth()->user()->can('index ProductsController') || auth()->user()->can('index StoresController')): ?>
                <li class="treeview">
                    <a href="#">
                        <i class="fa fa-barcode"></i>
                        <span><?php echo app('translator')->getFromJson('front.products'); ?></span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        <?php if($settings['industrial'] == 2): ?>
                            <li><a href="<?php echo e(route('products.index', ['is_raw' => true])); ?>"><i
                                        class="fa fa-hourglass-half"></i> <?php echo app('translator')->getFromJson('front.raw materials'); ?></a></li>
                            <li><a href="<?php echo e(route('getWorkOrders')); ?>"><i class="fa fa-hourglass-half"></i>
                                    <?php echo app('translator')->getFromJson('front.Manufacturing orders'); ?> </a></li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('products.index')); ?>"><i class="fa fa-th"></i> <?php echo app('translator')->getFromJson('front.products'); ?></a>
                        </li>
                        <?php if(auth()->user()->can('index ServicesController')): ?>
                            <li><a href="<?php echo e(route('services.index')); ?>"><i class="fa fa-fax"></i>
                                    <?php echo app('translator')->getFromJson('front.services'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('generateBarCode ProductsController')): ?>
                            <li><a href="<?php echo e(route('products.generateBarCode')); ?>"><i class="fa fa-barcode"></i>
                                    <?php echo app('translator')->getFromJson('front.barcode'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index MovementsController')): ?>
                            <li><a href="<?php echo e(route('movements.index')); ?>"><i class="fa fa-exchange"></i>
                                    <?php echo app('translator')->getFromJson('front.movements'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index DamagesController')): ?>
                            <li><a href="<?php echo e(route('damages.index')); ?>"><i class="fa fa-trash"></i>
                                    <?php echo app('translator')->getFromJson('front.damages'); ?></a></li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('products.priceList')); ?>"><i class="fa fa-money"></i> <?php echo app('translator')->getFromJson('front.pricelist'); ?>
                            </a></li>
                        <li><a href="<?php echo e(route('products.priceList2')); ?>"><i class="fa fa-money"></i> <?php echo app('translator')->getFromJson('front.advanced price List'); ?>
                            </a></li>
                        <li><a href="<?php echo e(route('offers.index')); ?>"><i class="fa fa-money"></i> <?php echo app('translator')->getFromJson('front.Price Offer'); ?>
                            </a></li>
                    </ul>
                </li>
            <?php endif; ?>
            <?php if(auth()->user()->can('index PersonsController')): ?>
                <li class="treeview">
                    <a href="#">
                        <i class="fa fa-users"></i> <span><?php echo app('translator')->getFromJson('front.persons'); ?></span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        <?php if(auth()->user()->can('clientIndex PersonsController')): ?>
                            <li><a href="<?php echo e(route('client.index')); ?>"><i class="fa fa-users"></i>
                                    <?php echo app('translator')->getFromJson('front.clients'); ?></a></li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('client.getCalander')); ?>"><i class="fa  fa-money"></i>
                                <?php echo app('translator')->getFromJson('front.Installments'); ?></a></li>
                        <li><a href="<?php echo e(route('client.index', ['isdebt' => true])); ?>"><i
                                    class="fa fa-calendar-minus-o"></i> <?php echo app('translator')->getFromJson('front.debt'); ?></a></li>
                        <li><a href="<?php echo e(route('persons.payments', ['fromdate' => date('Y-m-d')])); ?>"><i
                                    class="fa fa-money"></i> <?php echo app('translator')->getFromJson('front.clients payments'); ?></a></li>

                        <li><a href="<?php echo e(route('supplier.index')); ?>"><i class="fa fa-truck"></i><?php echo app('translator')->getFromJson('front.suppliers'); ?>
                            </a>
                        </li>
                        <li><a href="<?php echo e(route('supplier.index', ['isdebt' => true])); ?>"><i
                                    class="fa fa-truck"></i><?php echo app('translator')->getFromJson('front.suppliersdebt'); ?> </a></li>
                        <li><a href="<?php echo e(route('employees.index')); ?>"><i class="fa fa-user"></i>
                                <?php echo app('translator')->getFromJson('front.employees'); ?></a>
                        </li>
                        <li><a href="<?php echo e(route('partners.index')); ?>"><i class="fa fa-paw"></i> <?php echo app('translator')->getFromJson('front.partners'); ?> </a>
                        </li>

                    </ul>
                </li>
            <?php endif; ?>
            <?php if(auth()->user()->can('getSales OrdersController')): ?>
                <li class="treeview">
                    <a href="#">
                        <i class="fa fa-list-alt"></i>
                        <span><?php echo app('translator')->getFromJson('front.invoices'); ?></span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        <?php if(auth()->user()->can('getSales OrdersController')): ?>
                            <li><a href="<?php echo e(route('orders.index')); ?>"><i class="fa fa-line-chart"></i>
                                    <?php echo app('translator')->getFromJson('front.orders'); ?></a></li>
                            <li><a href="<?php echo e(route('orders.details')); ?>"><i class="fa fa-search-plus"></i>
                                    <?php echo app('translator')->getFromJson('front.orderdetails'); ?></a></li>
                            <li><a href="<?php echo e(route('ordersReturn.index')); ?>"><i class="fa fa-share-square-o"></i>
                                    <?php echo app('translator')->getFromJson('front.ordersreturns'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('getPurchases OrdersController')): ?>
                            <li><a href="<?php echo e(route('purchases.index')); ?>"><i
                                        class="fa fa-calendar-check-o"></i><?php echo app('translator')->getFromJson('front.purchases'); ?></a></li>
                            <li><a href="<?php echo e(route('purchasesReturn.index')); ?>"><i class="fa fa-share-square"></i>
                                    <?php echo app('translator')->getFromJson('front.purchasereturns'); ?></a></li>
                            <li><a href="<?php echo e(route('persons.getClientSupplier')); ?>"><i
                                        class="fa fa-desktop"></i><?php echo app('translator')->getFromJson('front.clientandsupplier'); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>
            <?php if(auth()->user()->can('index ExpensesController')): ?>
                <li class="treeview">
                    <a href="#">
                        <i class="fa fa-money"></i>
                        <span><?php echo app('translator')->getFromJson('front.finance'); ?></span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        <?php if(auth()->user()->can('addPayment PersonsController')): ?>
                            <li><a href="<?php echo e(route('persons.addTransaction', 'client')); ?>"><i class="fa fa-money"></i>
                                    سند قبض</a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('addPayment PersonsController')): ?>
                            <li><a href="<?php echo e(route('persons.addTransaction', 'supplier')); ?>"><i
                                        class="fa fa-money"></i> سند صرف</a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index ExpensesController')): ?>
                            <li><a href="<?php echo e(route('expenses.index')); ?>"><i class="fa fa-money"></i>
                                    <?php echo app('translator')->getFromJson('front.expenses'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index TresuryTranactionsController')): ?>
                            <li><a href="<?php echo e(route('tresurycurrency', 2)); ?>"><i
                                        class="fa fa-money"></i><?php echo app('translator')->getFromJson('front.treasury'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index BanksController')): ?>
                            <li><a href="<?php echo e(route('banks.index')); ?>"><i
                                        class="fa fa-credit-card"></i><?php echo app('translator')->getFromJson('front.bankaccounts'); ?></a></li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('currencies.index')); ?>"><i
                                    class="fa fa-bitcoin"></i><?php echo app('translator')->getFromJson('front.currency'); ?></a></li>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if(auth()->user()->can('dailyreport HomeController')): ?>
                <li class="treeview">
                    <a href="#">
                        <i class="fa fa-file"></i>
                        <span><?php echo app('translator')->getFromJson('front.reports'); ?></span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">

                        <li><a href="<?php echo e(route('reports.employees')); ?>"><i class="fa fa-users"></i>
                                تقرير الموظفين</a></li>
                        <li><a href="<?php echo e(route('reports.categories')); ?>"><i class="fa fa-th"></i>
                                تقرير الاقسام</a></li>
                        <li><a href="<?php echo e(route('orders.report')); ?>"><i class="fa fa-line-chart"></i>
                                <?php echo app('translator')->getFromJson('front.sales report'); ?></a></li>
                        <li><a href="<?php echo e(route('purchase.report')); ?>"><i class="fa fa-file"></i>
                                <?php echo app('translator')->getFromJson('front.Purchase report'); ?></a></li>
                        <li><a href="<?php echo e(route('expenses.report')); ?>"><i class="fa fa-money"></i>
                                <?php echo app('translator')->getFromJson('front.Expense report'); ?></a></li>
                        <li><a href="<?php echo e(route('ordersReturn.index')); ?>"><i class="fa fa-share-square-o"></i>
                                <?php echo app('translator')->getFromJson('front.ordersreturns'); ?></a></li>
                        <li><a href="<?php echo e(route('generaltaxreturnreport')); ?>?fromdate=<?php echo e(date('Y-m-01')); ?>"><i
                                    class="fa fa-file"></i> <?php echo app('translator')->getFromJson('front.General tax return report'); ?></a></li>
                        <li><a href="<?php echo e(route('purchasesReturn.index')); ?>"><i class="fa fa-share-square"></i>
                                <?php echo app('translator')->getFromJson('front.purchasereturns'); ?></a></li>
                        <li><a href="<?php echo e(route('persons.getClientSupplier')); ?>"><i
                                    class="fa fa-desktop"></i><?php echo app('translator')->getFromJson('front.clientandsupplier'); ?></a></li>
                        <li><a href="<?php echo e(route('dailyreport', ['fromdate' => date('Y-m-d')])); ?>"><i
                                    class="fa fa-calendar-check-o"></i><?php echo app('translator')->getFromJson('front.dailyreport'); ?></a></li>
                        <li><a href="<?php echo e(route('profit')); ?>"><i class="fa fa-line-chart"></i><?php echo app('translator')->getFromJson('front.profitreport'); ?></a>
                        </li>
                        <li><a href="<?php echo e(route('gprofit')); ?>"><i class="fa fa-line-chart"></i>تقرير الأرباح الفعلى</a>
                        </li>
                        <li><a href="<?php echo e(route('products.report')); ?>"><i
                                    class="fa fa-barcode"></i><?php echo app('translator')->getFromJson('front.productsreport'); ?></a></li>
                        <li><a href="<?php echo e(route('products.report', ['is_service' => 1])); ?>"><i
                                    class="fa fa-fax"></i><?php echo app('translator')->getFromJson('front.servicesreport'); ?></a></li>
                        <li><a href="<?php echo e(route('products.getCriticalQuantity')); ?>"><i class="fa fa-battery-1"></i>
                                <?php echo app('translator')->getFromJson('front.requiredproducts'); ?></a></li>
                        <li><a href="<?php echo e(route('regionsReport')); ?>"><i class="fa fa-area-chart"></i>
                                <?php echo app('translator')->getFromJson('front.regions report'); ?></a></li>
                        <li>
                            <a class="hide" href="<?php echo e(route('representativesReport')); ?>"><i
                                    class="fa fa-truck"></i> <?php echo app('translator')->getFromJson('front.debts representatives'); ?> </a>
                            <a href="<?php echo e(route('employees.getSalesManReport')); ?>"><i class="fa fa-truck"></i> تقرير
                                المناديب</a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('representativesSalesReport')); ?>"><i class="fa fa-truck"></i>
                                <?php echo app('translator')->getFromJson('front.Sales representatives'); ?></a>
                        </li>


                        <?php if($settings['industrial'] == 2): ?>
                            <li>
                                <a href="<?php echo e(route('allworkorders')); ?>"><i class="fa fa-truck"></i>
                                    <?php echo app('translator')->getFromJson('front.Manufacturing Report'); ?></a>
                            </li>
                        <?php endif; ?>
                        <li>
                            <a href="<?php echo e(route('summery')); ?>"><i class="fa fa-file"></i> <?php echo app('translator')->getFromJson('front.summery report'); ?></a>
                        </li>
                        <li><a href="<?php echo e(route('logs')); ?>"><i class="fa fa-history"></i><?php echo app('translator')->getFromJson('front.Activity Log'); ?></a></li>

                    </ul>
                </li>
            <?php endif; ?>

            <?php if(auth()->user()->can('index UsersController')): ?>
                <li class="treeview">
                    <a href="#">
                        <i class="fa fa-lock"></i>
                        <span><?php echo app('translator')->getFromJson('front.Users and Roles'); ?></span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        <?php if(auth()->user()->can('index RolesController')): ?>
                            <li><a href="<?php echo e(route('roles.index')); ?>"><i
                                        class="fa fa-user-secret"></i><?php echo app('translator')->getFromJson('front.roles'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index UsersController')): ?>
                            <li><a href="<?php echo e(route('users.index')); ?>"><i
                                        class="fa fa-users"></i><?php echo app('translator')->getFromJson('front.users'); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>

            <?php if(auth()->user()->can('index SettingController')): ?>
                <li class="treeview">
                    <a href="#">
                        <i class="fa fa-book"></i>
                        <span><?php echo app('translator')->getFromJson('front.System Setup'); ?></span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        <li>
                            <a href="<?php echo e(route('regions.index')); ?>"><i class="fa fa-map-marker"></i>
                                <?php echo app('translator')->getFromJson('front.regions'); ?></a>
                        </li>
                        <?php if(auth()->user()->can('index UnitsController')): ?>
                            <li><a href="<?php echo e(route('units.index')); ?>"><i class="fa fa-cubes"></i>
                                    <?php echo app('translator')->getFromJson('front.units'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index StoresController')): ?>
                            <li><a href="<?php echo e(route('stores.index')); ?>"><i class="fa fa-bank"></i>
                                    <?php echo app('translator')->getFromJson('front.stores'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index CategoriesController')): ?>
                            <li><a href="<?php echo e(route('category.index')); ?>"><i
                                        class="fa fa-qrcode"></i><?php echo app('translator')->getFromJson('front.categories'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index ExpensesTypeController')): ?>
                            <li><a href="<?php echo e(route('expensesType.index')); ?>"><i class="fa fa-money"></i>
                                    <?php echo app('translator')->getFromJson('front.ExpensesTypeController'); ?></a></li>
                        <?php endif; ?>
                        <?php if(auth()->user()->can('index DamageOptionController')): ?>
                            <li><a href="<?php echo e(route('damageOptions.index')); ?>"><i class="fa fa-list"></i>
                                    <?php echo app('translator')->getFromJson('front.damageOptions'); ?></a></li>
                        <?php endif; ?>
                    </ul>
                </li>
            <?php endif; ?>


            <?php if(auth()->user()->can('index SettingController')): ?>
                <li class="treeview">
                    <a href="#">
                        <i class="fa fa-cogs"></i>
                        <span><?php echo app('translator')->getFromJson('front.settings'); ?></span>
                        <span class="pull-right-container">
                            <i class="fa fa-angle-left pull-right"></i>
                        </span>
                    </a>
                    <ul class="treeview-menu">
                        <li><a href="<?php echo e(route('setting.index')); ?>"><i class="fa fa-cog"></i><?php echo app('translator')->getFromJson('front.settings'); ?></a>
                        </li>
                        <li><a href="<?php echo e(route('backup')); ?>"><i class="fa fa-database"></i><?php echo app('translator')->getFromJson('front.backup'); ?></a></li>
                        <li><a href="<?php echo e(route('restore')); ?>"><i class="fa fa-database"></i><?php echo app('translator')->getFromJson('front.restore'); ?></a>
                        </li>
                        <li><a class="showAlertWarning" href="<?php echo e(route('closeYear')); ?>"><i
                                    class="fa fa-calendar"></i><?php echo app('translator')->getFromJson('front.closeyear'); ?></a></li>
                        <li><a href="<?php echo e(route('clearCache')); ?>"><i class="fa fa-eraser"></i><?php echo app('translator')->getFromJson('front.clearcache'); ?></a>
                        </li>
                        <li><a href="<?php echo e(route('migrate')); ?>"><i class="fa fa-copy"></i><?php echo app('translator')->getFromJson('front.migrate'); ?></a></li>
                        <?php if(isset($settings['onlineurl']) && $settings['onlineurl']): ?>
                            <li><a href="<?php echo e(route('sync')); ?>"><i class="fa fa-upload"></i><?php echo app('translator')->getFromJson('front.sync'); ?> </a>
                            </li>
                        <?php endif; ?>
                        <li><a href="<?php echo e(route('updateProductPricePersent')); ?>"><i class="fa fa-percent"></i>تطبيق
                                نسبة زيادة السعر</a></li>
                        <li><a class="showAlertWarning" href="<?php echo e(route('cleanDB')); ?>"><i
                                    class="fa fa-trash-o"></i><?php echo app('translator')->getFromJson('front.cleandb'); ?> </a></li>
                    </ul>
                </li>
            <?php endif; ?>
        </ul>
    </section>
    <!-- /.sidebar -->
</aside>
