<?php
	$title = '';
    $route = '';
    if($type=='client'){
        $title = trans('front.clients');
        $route = route('client.create');
    }elseif($type=='supplier'){
        $title = trans('front.suppliers');
        $route = route('supplier.create');
    }


?>
<?php $__env->startSection('title',$title); ?>
<?php $__env->startSection('content'); ?>
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
			<?php echo e($title); ?>

			<a data-toggle="modal" data-target="#myModal" class="btn btn-success pull-right" href="<?php echo e($route); ?>" ><i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('front.Add'); ?></a>
		</h1>
	</section>

	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
				
				<!-- /.box-header -->
					<div class="box-body">
						<table class="dataTableList table table-striped table-bordered" style="width: 100%">
							<thead>
							<tr>
								<th>#</th>
                                <th><?php echo app('translator')->getFromJson('front.name'); ?></th>
                                <th><?php echo app('translator')->getFromJson('front.region'); ?></th>
								<th><?php echo app('translator')->getFromJson('front.telephone'); ?></th>
								<th><?php echo app('translator')->getFromJson('front.balance'); ?> </th>
                                <th><?php echo app('translator')->getFromJson('front.support'); ?></th>
								<th class="no-sort"></th>
							</tr>
							</thead>
							<tbody>

							</tbody>
						</table>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->

	<div id="myModal" class="modal fade" style="overflow:hidden;" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title"></h4>
				</div>
				<div class="modal-body">
					<p class="text-center"><div class="fa-3x text-center"><i class="fa fa-cog fa-spin"></i>                    <?php echo app('translator')->getFromJson('front.Loading ....'); ?>                </div>                </p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-outline pull-left" data-dismiss="modal">إغلاق</button>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('dataTableJs'); ?>
    <script>
        var pageUrl = "<?php echo e($type=='client'?route('client.index'):route('supplier.index')); ?>";
        var columns= [
            {data: "id", name: "id"},
            {data: "name", name: "name"},
            {data: "regionname", name: "region.name"},
            {data: "mobileData", name: "mobile"},
            {data: "balnce_text", name: "balnce_text", orderable: false, searchable: false},
            {data: "remember_review_balance", name: "remember_review_balance"},
            {data:'actions',name:'actions', orderable: false, searchable: false}

        ];
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>