@extends('layouts.app')
@section('title','تقرير الموظفين')
@section('content')
	<!-- Content Header (Page header) -->

	<section class="content-header">
		<h1>
			تقرير الموظفين
		</h1>
	</section>

	<!-- Main content -->
	<section class="content">
        <div class="row">
            <div class="col-lg-6 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-primary">
                    <div class="inner">
                        <h3 id="totalOrder">{{$totalResults->total_orders??0}}</h3>
                        <p>عدد الفواتير</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-list-alt"></i>
                    </div>
                </div>
            </div>
            <!-- ./col -->
            <div class="col-lg-6 col-xs-6">
                <!-- small box -->
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3>{{$totalResults->total_amount??0}}</h3>
                        <p>إجمالى المبلغ</p>
                    </div>
                    <div class="icon">
                        <i class="fa fa-money"></i>
                    </div>
                </div>
            </div>
        </div>
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
				 <div class="box-header">
                     <div class="row hideprint" style="margin-top: 10px;">
                         <div class="col-md-12">
                             <form action="" method="get">
                                 <div class="col-md-5">
                                     <div class="form-group ">
                                         <input id="fromdate" placeholder="@lang('front.datefrom')" autocomplete="off" style="direction: rtl;" name="fromdate" value="{{request()->fromdate}}" type="text" class="form-control datepicker">
                                     </div>
                                 </div>
                                 <div class="col-md-5">
                                     <div class="form-group">
                                         <input id="todate" placeholder="@lang('front.dateto')" autocomplete="off" style="direction: rtl;" name="todate" value="{{request()->todate}}" type="text" class="form-control datepicker">
                                     </div>
                                 </div>
                                 <div class="col-md-2">
                                     <button  type="submit" class="btn btn-primary form-control">@lang('front.search')</button>
                                 </div>
                             </form>
                         </div>
                     </div>
                 </div>
				<!-- /.box-header -->
					<div class="box-body">
						<table id="dataList" class="table table-bordered table-striped">
							<thead>
								<tr>
									<th>اسم الموظف</th>
									<th>عدد الفواتير</th>
                                    <th>إجمالي المبلغ</th>
								</tr>
							</thead>
                            <tbody>
                                @foreach ($results as $result)
                                    <tr>
                                        <td>{{optional($result->employee)->name}}</td>
                                        <td>{{$result->total_orders}}</td>
                                        <td>{{$result->total_amount}}</td>
                                    </tr>
                                @endforeach
                            </tbody>
						</table>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->
@endsection
@push('js')
    <script>
        $('.datepicker').datepicker({
            autoclose: true,
            rtl: true,
            format: 'yyyy-mm-dd',
            language: "{{\Session::get('locale')}}",
        });
        $(".select2").select2({allowClear: true});
    </script>
@endpush
