<?php $__env->startSection('title',trans('front.shipments')); ?>
<?php $__env->startSection('content'); ?>
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
			<?php echo app('translator')->getFromJson('front.shipments'); ?>
			<a class="btn btn-success pull-right" href="<?php echo e(route('shipments.create')); ?>" ><i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('front.Add'); ?></a>
            <?php if(auth()->user()->can('truncateShipments ShipmentsController')): ?>
                <a class="btn btn-danger" href="<?php echo e(route('shipments.truncateData')); ?>" ><i class="fa fa-trash"></i> مسح كل الشحنات</a>
            <?php endif; ?>
        </h1>
	</section>

	<!-- Main content -->
	<section class="content">
        <div class="row hideprint" style="margin-top: 10px;">
            <div class="col-md-12">
                <form action="" method="get">
                    <?php
                        $colclass = isset($settings['show_shipment_company']) && $settings['show_shipment_company']==1?'col-md-2':'col-md-3';
                    ?>
                    <div class="form-group col-md-2 shipmentCompany">
                        <select name="sender" data-ajax--url="<?php echo e(route('companies.index')); ?>" data-ajax--cache="true" data-placeholder="الشركة" id="companyList"  class="form-control select2">
                            <option data-mobile="" value="">الشركة</option>
                            <?php $__currentLoopData = \App\Company::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option <?php echo e($reg->id == request('sender')?'selected':''); ?> value="<?php echo e($reg->id); ?>"><?php echo e($reg->sender_name); ?> - <?php echo e($reg->sender_mobile); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="<?php echo e($colclass); ?>">
                        <div class="form-group ">
                            <input id="fromdate" placeholder="<?php echo app('translator')->getFromJson('front.datefrom'); ?>" autocomplete="off" style="direction: rtl;" name="fromdate" value="<?php echo e(request()->fromdate); ?>" type="text" class="form-control datepicker">
                        </div>
                    </div>
                    <div class="<?php echo e($colclass); ?>">
                        <div class="form-group">
                            <input id="todate" placeholder="<?php echo app('translator')->getFromJson('front.dateto'); ?>" autocomplete="off" style="direction: rtl;" name="todate" value="<?php echo e(request()->todate); ?>" type="text" class="form-control datepicker">
                        </div>
                    </div>
                    <div class="col-md-2">
                        <div class="form-group">
                            <?php
                                $statusList = ['تأجيل','تم التسليم','لم يتم التسليم','معلقة'];
                            ?>
                            <select id="shipping_status" name="shipping_status" class="form-control">
                                <option value="">--- الكل ---</option>
                                <?php $__currentLoopData = $statusList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(request('shipping_status')==$status?'selected':''); ?> value="<?php echo e($status); ?>"><?php echo e($status); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <input value="<?php echo e(request('id')); ?>" name="id" placeholder="كلمة البحث" type="text" autocomplete="off" class="form-control">
                        </div>
                    </div>
                    <div class="col-md-9">
                        <div class="form-group">
                            <?php
                                $prodStatusList = ['تأجيل','مرتجع','مستلم','تدوير','معلقة','تفاوض','مغلق','لا يرد'];
                            ?>
                            <select multiple name="product_status[]" class="form-control select2">
                                <option <?php echo e(is_array(request('product_status'))&&in_array('الكل',request('product_status'))?'selected':''); ?> value="الكل">الكل</option>
                                <?php $__currentLoopData = $prodStatusList; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option <?php echo e(is_array(request('product_status'))&&in_array($status,request('product_status'))?'selected':''); ?> value="<?php echo e($status); ?>"><?php echo e($status); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <button  type="submit" class="btn btn-primary form-control"><i class="fa fa-search"></i> بحث</button>
                    </div>


                </form>
            </div>
        </div>
		<div class="row">
            <div class="col-xs-12">
				<div class="box">
					<div class="box-body">
                        <div class="col-md-12">
                            <div class="row">
                                <?php
                                $cardClass = 'col-md-4 col-sm-6';
                                if(auth()->user()->can('profit HomeController')){
                                    $cardClass = 'col-md-3 col-sm-6';
                                }
                                ?>
                                <div class="<?php echo e($cardClass); ?> col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-green"><i class="fa fa-cart-plus"></i></span>

                                        <div class="info-box-content">
                                            <span class="info-box-text">المبيعات</span>
                                            <span style="width: 100%;margin-top: 5px;" class="info-box-number badge bg-green">
                            <?php echo e($result['totalSales']??0); ?> <?php echo e(currency()->getCurrency()['symbol']??'ج.م'); ?>

                            </span>
                                        </div>
                                        <!-- /.info-box-content -->
                                    </div>
                                    <!-- /.info-box -->
                                </div>
                                <!-- /.col -->
                                <div class="<?php echo e($cardClass); ?> col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-yellow"><i class="fa fa-share-square-o"></i></span>

                                        <div class="info-box-content">
                                            <span class="info-box-text">المرتجعات</span>
                                            <span style="width: 100%;margin-top: 5px;" class="info-box-number badge bg-yellow">
                            <?php echo e($result['totalReturn']??0); ?> قطعة
                        </span>
                                        </div>
                                        <!-- /.info-box-content -->
                                    </div>
                                    <!-- /.info-box -->
                                </div>
                                <div class="<?php echo e($cardClass); ?> col-xs-12">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-red"><i class="fa fa-truck"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">الشحن</span>
                                            <span style="width: 100%;margin-top: 5px;" class="info-box-number badge bg-red">
                                <?php echo e($result['totalShipping']??0); ?> <?php echo e(currency()->getCurrency()['symbol']??'ج.م'); ?>

                            </span>
                                        </div>
                                        <!-- /.info-box-content -->
                                    </div>
                                    <!-- /.info-box -->
                                </div>
                                <!-- /.col -->
                                <!-- fix for small devices only -->
                                <div class="clearfix visible-sm-block"></div>
                                <?php if(auth()->user()->can('profit HomeController')): ?>
                                    <div class="col-md-3 col-sm-6 col-xs-12">
                                        <div class="info-box">
                                            <span class="info-box-icon bg-aqua"><i class="fa fa-money"></i></span>

                                            <div class="info-box-content">
                                                <span class="info-box-text"></span>الأرباح
                                                <span style="width: 100%;margin-top: 5px;" class="info-box-number badge bg-aqua">
                                <?php echo e($result['totalProfit']??0); ?> <?php echo e(currency()->getCurrency()['symbol']??'ج.م'); ?>

                            </span>
                                            </div>
                                            <!-- /.info-box-content -->
                                        </div>
                                        <!-- /.info-box -->
                                    </div>
                                    <!-- /.col -->
                                <?php endif; ?>
                            </div>
                        </div>
						<table class="table table-bordered table-striped">
							<thead>
							<tr>
								<td>#</td>
                                <th>المستخدم</th>
                                <th>رقم الشحنة</th>
                                <th>تاريخ الشحنة</th>
                                <th>مكتب الشحن</th>
                                <th>حالة الشحنة</th>
                                <th>إجمالى الشحنة</th>
                                <th>إجمالى الشحن</th>
								<th class="no-sort"></th>
							</tr>
							</thead>
							<tbody>
							<?php $__currentLoopData = $shipments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $shipment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e(optional($shipment->user)->name); ?></td>
                                    <td><?php echo e($shipment->id); ?></td>
                                    <td><?php echo e($shipment->date_ar); ?></td>
                                    <td><?php echo e($shipment->shipping_office); ?></td>
                                    <td><?php echo e($shipment->shipping_status); ?></td>
                                    <td><?php echo e($shipment->total); ?></td>
                                    <td><?php echo e($shipment->total_shipping); ?></td>
									<td class="actions">
										<a href="<?php echo e(route('shipments.edit',$shipment)); ?>" class="btn btn-primary btn-xs">
											<i class="fa fa-pencil fa-fw" aria-hidden="true"></i>
											<?php echo app('translator')->getFromJson('front.edit'); ?>
										</a>
                                        <a href="<?php echo e(route('shipments.show',$shipment)); ?>" class="btn btn-warning btn-xs">
                                            <i class="fa fa-eye fa-fw" aria-hidden="true"></i>
                                            التفاصيل
                                        </a>
                                        <a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('shipments.updateShipping',$shipment)); ?>" class="btn btn-success btn-xs">
                                            <i class="fa fa-truck" aria-hidden="true"></i>
                                            الشحن
                                        </a>
                                        <a href="<?php echo e(route('shipments.invoices',$shipment)); ?>" class="btn btn-info btn-xs">
                                            <i class="fa fa-file fa-fw" aria-hidden="true"></i>
                                            الفواتير
                                        </a>
										<a class="btn btn-xs btn-danger remove-record"  data-url="<?php echo e(route('shipments.destroy',$shipment)); ?>" data-id="<?php echo e($shipment->id); ?>">
											<i class="fa fa-trash"></i>
											<?php echo app('translator')->getFromJson('front.delete'); ?>
										</a>
									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>
                    <div class="box-footer text-center">
                        <?php echo e($shipments->render()); ?>

                    </div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .info-box {
            background: #ecf0f5;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        $('.datepicker').datepicker({
            autoclose: true,
            rtl: true,
            format: 'yyyy-mm-dd',
            language: "<?php echo e(\Session::get('locale')); ?>",
        });
        $(".select2").select2({allowClear: true});
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>