<?php
	if($type=='sales'){
        $title = trans('front.ordersreturns');
        $route = route('orderReturn.create');
    }else{
        $title = trans('front.purchasereturns');
        $route = route('purchaseReturn.create');
    }

?>
<?php $__env->startSection('title',$title); ?>
<?php $__env->startSection('content'); ?>
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
			<?php echo e($title); ?>

			<a class="btn btn-success pull-right" href="<?php echo e($route); ?>" ><i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('front.Add'); ?></a>
		</h1>
	</section>

	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
				
				<!-- /.box-header -->
					<div class="box-body">
						<table id="dataList" class="table table-fixed table-bordered table-striped">
							<thead>
								<tr>
									<th>#</th>
                                    <th>المستخدم</th>
									<th><?php echo app('translator')->getFromJson('front.date'); ?></th>
									<?php if($type=='sales'): ?>
										<th><?php echo app('translator')->getFromJson('front.client'); ?></th>
									<?php else: ?>
										<th><?php echo app('translator')->getFromJson('front.supplier'); ?></th>
									<?php endif; ?>
                                    <th><?php echo app('translator')->getFromJson('front.sale'); ?></th>
									<th><?php echo app('translator')->getFromJson('front.total'); ?></th>
									<th><?php echo app('translator')->getFromJson('front.salediscount'); ?></th>
									<th><?php echo app('translator')->getFromJson('front.payment'); ?></th>
									<th class="no-sort"></th>
								</tr>
							</thead>
							<tbody>
							<?php $__currentLoopData = $returns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $return): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td><?php echo e($loop->iteration); ?></td>
                                    <td><?php echo e(optional($return->creator)->name); ?></td>
									<td><?php echo e($return->return_date); ?></td>
                                    <td><?php echo e(optional($return->client)->name); ?></td>
                                    <td><?php echo e(optional($return->saleMan)->name); ?></td>
									<td>
										<?php echo e(currency($return->return_value,$return->currency, $return->currency, $format = true)); ?>

									</td>
									<td>
										<?php echo e(currency($return->sales_value,$return->currency, $return->currency, $format = true)); ?>

									</td>
									<td>
										<?php echo e($return->is_cash?trans('front.cash'):trans('front.from previous balance')); ?>

									</td>
									<td class="actions">
										<a href="<?php echo e(route('returns.edit',$return)); ?>" class="btn btn-primary btn-xs">
											<i class="fa fa-pencil fa-fw" aria-hidden="true"></i>
											<?php echo app('translator')->getFromJson('front.edit'); ?>
										</a>
										<a data-toggle="modal" data-target="#addPersonModal"  href="<?php echo e(route('returns.show',$return)); ?>" class="btn btn-warning btn-xs">
											<i class="fa fa-eye fa-fw" aria-hidden="true"></i>
											 <?php echo app('translator')->getFromJson('front.show'); ?>
										</a>
										<a class="btn btn-xs btn-danger remove-record" data-toggle="modal" data-url="<?php echo e(route('returns.destroy',$return)); ?>" data-id="<?php echo e($return->id); ?>" data-target="#custom-width-modal">
											<i class="fa fa-trash"></i>
											<?php echo app('translator')->getFromJson('front.delete'); ?>
										</a>

									</td>
								</tr>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</tbody>
						</table>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->



<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
	<style>
		div.dataTables_paginate {
			text-align: left;
		}
		#myModal .modal-dialog {
			width: 100%;
			height: 100%;
			margin: 0;
			padding: 0;
		}

		#myModal .modal-content {
			height: auto;
			min-height: 100%;
			breturn: 0 none;
			breturn-radius: 0;
		}
		.typeahead {
				z-index: 1051;
				direction: rtl;
		}

		.twitter-typeahead {
			width: 100%;
		}
		.tt-query {
			-webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
			-moz-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
			box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
		}

		.tt-hint {
			color: #999
		}

		.tt-menu {    /* used to be tt-dropdown-menu in older versions */
			width: 380px;
			margin-top: 2px;
			padding: 4px 0;
			background-color: #fff;
			breturn: 1px solid #ccc;
			breturn: 1px solid rgba(0, 0, 0, 0.2);
			-webkit-breturn-radius: 4px;
			-moz-breturn-radius: 4px;
			breturn-radius: 4px;
			-webkit-box-shadow: 0 5px 10px rgba(0,0,0,.2);
			-moz-box-shadow: 0 5px 10px rgba(0,0,0,.2);
			box-shadow: 0 5px 10px rgba(0,0,0,.2);
		}

		.tt-suggestion {
			padding: 3px 20px;
			line-height: 24px;
			direction: rtl;
		}

		.tt-suggestion.tt-cursor,.tt-suggestion:hover {
			color: #fff;
			background-color: #0097cf;

		}

		.tt-suggestion p {
			margin: 0;
		}


	</style>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>