<!DOCTYPE html>
<html dir="rtl">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <title><?php echo app('translator')->getFromJson('front.login'); ?></title>
    <!-- Tell the browser to be responsive to screen width -->
    <meta content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no" name="viewport">
    <!-- Bootstrap 3.3.6 -->
    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/bootstrap4.min.css">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/font-awesome.min.css">
    <link rel="stylesheet" href="<?php echo e(asset('front/dist')); ?>/css/AdminLTE.min.css">
    <?php if(\App::getLocale('locale') == 'ar'): ?>
        <link rel="stylesheet" href="<?php echo e(asset('front/dist')); ?>/css/AdminLTE-rtl.min.css">
    <?php endif; ?>

    <link rel="stylesheet" href="<?php echo e(asset('front')); ?>/login.css">
</head>
<body>
    <div class="container-fluid px-1 px-md-5 px-lg-1 px-xl-5 py-3 mx-auto">
        <div class="card card0 border-0">
            <div class="row d-flex">
                <div class="col-lg-6">
                    <div class="card2 card border-0 px-4 py-5">
                        <div class="row mb-4">
                            <h1 class="mb-0 mt-2">
                                <b><?php echo e(config('developer.appname_'.App::getLocale())); ?></b>
                            </h1>
                            <small style=" position: absolute; left: 0; " class="font-weight-bold">
                                <a href="<?php echo e(route('changeLang',App::getLocale()=='ar'?'en':'ar')); ?>">
                                    <?php echo e(App::getLocale()=='ar'?'EN':'العربية'); ?>

                                </a>
                            </small>
                        </div>
                        <div class="row px-3 mb-4">
                            <div class="line"></div>
                            <small class="or text-center"><?php echo app('translator')->getFromJson('front.login'); ?></small>
                            <div class="line"></div>
                        </div>

                        <form action="<?php echo e(route('login')); ?>" method="post">
                            <?php echo e(csrf_field()); ?>

                            <div class="row px-3">
                                <label class="mb-1">
                                    <h6 class="mb-0 text-sm"><?php echo app('translator')->getFromJson('front.username'); ?></h6>
                                </label>
                                <input required="" value="<?php echo e(optional(\App\User::orderBy('id','DESC')->first())->email); ?>" class="mb-4" type="text" name="email" placeholder="<?php echo app('translator')->getFromJson('front.username'); ?>">
                            </div>
                            <div class="row px-3"> <label class="mb-1">
                                <h6 class="mb-0 text-sm"><?php echo app('translator')->getFromJson('front.password'); ?></h6>
                            </label> <input required="" type="password" name="password" placeholder="<?php echo app('translator')->getFromJson('front.password'); ?>"> </div>
                            <div class="row px-3 mb-4">
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input id="chk1" type="checkbox" name="remember" class="custom-control-input form-control">
                                    <label for="chk1" class="custom-control-label text-sm"><?php echo app('translator')->getFromJson('front.Remember me'); ?></label>
                                </div>
                            </div>
                            <div class="row mb-3 px-3">
                                <button type="submit" class="btn btn-blue text-center"><?php echo app('translator')->getFromJson('front.login'); ?></button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="card1 pb-5">
                        <?php if(config('developer.logo')): ?>
                        <div class="row">
                            <img style="<?php echo e(config('developer.logoStyle')); ?>" src="<?php echo e(config('developer.logo')); ?>" class="logo">
                         </div>
                         <?php endif; ?>
                        <div class="row px-3 justify-content-center mb-5 border-line">
                            <img style="<?php echo e(config('developer.mainImgStyle')); ?>" src="<?php echo e(asset('front')); ?>/<?php echo e(config('developer.mainImg')); ?> " class="image">
                        </div>
                    </div>
                </div>
            </div>
            <div class="bg-blue py-4">
                <div class="row px-3">
                    <small class="ml-4 ml-sm-5 mb-2 mr-4">
                    <?php echo app('translator')->getFromJson('front.copyright'); ?> &copy; 2023 <?php echo app('translator')->getFromJson('front.Designed and Developed By'); ?> <?php echo e(config('developer.developer_'.App::getLocale())); ?>

                    </small>
                </div>
            </div>
        </div>
    </div>

       <!-- jQuery 2.2.3 -->
    <script src="<?php echo e(asset('front/plugins')); ?>/jQuery/jquery-2.2.3.min.js"></script>
    <!-- Bootstrap 3.3.6 -->
    <script src="<?php echo e(asset('front/bootstrap')); ?>/js/bootstrap.min.js"></script>
</body>
</html>
