<?php

if($type==1)
	$title = trans('front.banks');
else
	$title = trans('front.treasury');
?>
<?php $__env->startSection('title',$title); ?>
<?php $__env->startSection('content'); ?>
	<!-- Content Header (Page header) -->
	<section class="content-header">
		<h1>
<?php echo e($title); ?>

<a data-toggle="modal" data-target="#myModal" class="btn btn-success pull-right" href="<?php echo e(route('banks.create',['type'=>$type])); ?>" ><i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('front.Add'); ?></a>

		</h1>
	</section>

	<!-- Main content -->
	<section class="content">
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
				
				<!-- /.box-header -->
					<div class="box-body">
						<?php if($type==1): ?>
							<table id="dataList" class="table table-bordered table-striped">
								<thead>
								<tr>
									<th>#</th>
									<th><?php echo app('translator')->getFromJson('front.bankname'); ?></th>
									<th><?php echo app('translator')->getFromJson('front.accountNumber'); ?></th>
									
									<th><?php echo app('translator')->getFromJson('front.balance'); ?></th>
									
									<th class="no-sort"></th>
								</tr>
								</thead>
								<tbody>
								<?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($loop->iteration); ?></td>
										<td><?php echo e($bank->name); ?></td>
										<td><?php echo e($bank->number); ?></td>
										
										<td><?php echo e(currency($bank->balance,$bank->currency,$bank->currency, $format = true)); ?></td>
										
										<td class="actions">
											<a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('banks.edit',$bank)); ?>" class="btn btn-primary btn-xs">
												<i class="fa fa-pencil fa-fw" aria-hidden="true"></i>
												<?php echo app('translator')->getFromJson('front.edit'); ?>
											</a>
											<a class="btn btn-xs btn-danger remove-record" data-url="<?php echo e(route('banks.destroy',$bank)); ?>" data-id="<?php echo e($bank->id); ?>">
												<i class="fa fa-trash"></i>
												<?php echo app('translator')->getFromJson('front.delete'); ?>
											</a>
											<a href="<?php echo e(route('banks.show',$bank)); ?>" class="btn btn-warning btn-xs">
												<i class="fa fa-eye" aria-hidden="true"></i>
												<?php echo app('translator')->getFromJson('front.show'); ?>
											</a>

											<a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('banks.addTransaction',$bank)); ?>" class="btn btn-info btn-xs">
												<i class="fa fa-money" aria-hidden="true"></i>
												<?php echo app('translator')->getFromJson('front.depositandwithdrawal'); ?>
											</a>
										</td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						<?php else: ?>
							<table id="dataList" class="table table-bordered table-striped">
								<thead>
								<tr>
									<th>#</th>
									<th><?php echo app('translator')->getFromJson('front.treasury'); ?></th>
									<th><?php echo app('translator')->getFromJson('front.currentbalance'); ?></th>
									<th><?php echo app('translator')->getFromJson('front.currency'); ?></th>
									<th class="no-sort"></th>
								</tr>
								</thead>
								<tbody>
								<?php $__currentLoopData = $banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>
										<td><?php echo e($loop->iteration); ?></td>
										<td><?php echo e($bank->name); ?></td>
										<td><?php echo e(currency($bank->balance,$bank->currency,$bank->currency, $format = true)); ?></td>
										<td><?php echo e($bank->currency); ?></td>
										<td class="actions">
											<a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('banks.edit',$bank)); ?>" class="btn btn-primary btn-xs">
												<i class="fa fa-pencil fa-fw" aria-hidden="true"></i>
												<?php echo app('translator')->getFromJson('front.edit'); ?>
											</a>
                                            <?php if(!$loop->first): ?>
											<a class="btn btn-xs btn-danger remove-record" data-url="<?php echo e(route('banks.destroy',$bank)); ?>" data-id="<?php echo e($bank->id); ?>">
												<i class="fa fa-trash"></i>
												<?php echo app('translator')->getFromJson('front.delete'); ?>
											</a>
                                            <?php endif; ?>
											<a href="<?php echo e(route('banks.show',$bank)); ?>" class="btn btn-warning btn-xs">
												<i class="fa fa-eye" aria-hidden="true"></i>
												<?php echo app('translator')->getFromJson('front.show'); ?>
											</a>

											<a data-toggle="modal" data-target="#myModal" href="<?php echo e(route('banks.addTransaction',$bank)); ?>" class="btn btn-info btn-xs">
												<i class="fa fa-money" aria-hidden="true"></i>
												<?php echo app('translator')->getFromJson('front.depositandwithdrawal'); ?>
											</a>
										</td>
									</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
								</tbody>
							</table>
						<?php endif; ?>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->

	<div id="myModal" class="modal fade" style="overflow:hidden;" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog">
			<div class="modal-content">
				<div class="modal-header">
					<button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
					<h4 class="modal-title"></h4>
				</div>
				<div class="modal-body">
					<p class="text-center"><div class="fa-3x text-center"><i class="fa fa-cog fa-spin"></i>                    <?php echo app('translator')->getFromJson('front.Loading ....'); ?>                </div>                </p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-outline pull-left" data-dismiss="modal">إغلاق</button>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>