<?php $__env->startSection('title', trans('front.summary') . ' ' . $person->name); ?>
<?php $__env->startSection('content'); ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <h1>
            <?php echo app('translator')->getFromJson('front.summary'); ?>
            <small>
                <?php echo e($person->name); ?>

            </small>
            <a onclick="window.print();" href="javascript:void(0)" class=" btn btn-lg print pull-right"><i class="fa fa-print"
                    aria-hidden="true"></i></a>
        </h1>
    </section>
    <!-- Main content -->
    <section class="content">
        <?php echo $__env->make('layouts.partial.printHeader', ['showCompanyData' => true], array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        <?php echo $__env->make('layouts.partial.filter', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>
        
        <div class="row">
            <div class="col-md-12">
                <div class="box">
                    <div class="box-body">
                        <table class="table table-bordered">
                            <tr class="warning">
                                <td>#</td>
                                <td><?php echo e($person->id); ?></td>
                                <td><?php echo app('translator')->getFromJson('front.name'); ?></td>
                                <td><?php echo e($person->name); ?></td>
                            </tr>
                            <tr class="active">
                                <td><?php echo app('translator')->getFromJson('front.address'); ?></td>
                                <td><?php echo e($person->address); ?> - <?php echo e(optional($person->region)->name); ?></td>
                                <td><?php echo app('translator')->getFromJson('front.mobile'); ?></td>
                                <td>
                                    <?php echo e($person->mobile); ?>

                                    <?php echo e($person->mobile2 ? '-' . $person->mobile2 : ''); ?>

                                </td>
                            </tr>
                            <tr class="danger">
                                <td><?php echo app('translator')->getFromJson('front.total'); ?></td>
                                <td>
                                    <?php
                                        $totaltra = $orders->sum('total');
                                        if ($sales_returns) {
                                            $totaltra -= abs($sales_returns->sum('return_value'));
                                        }
                                        
                                    ?>
                                    <?php echo e(currency(round($totaltra, 2), currency()->config('default'), currency()->getUserCurrency(), true)); ?>

                                    <br /><br /><span class="bg-success">إجمالى الفواتير - إجمالى المرتجعات</span>
                                </td>
                                <td><?php echo app('translator')->getFromJson('front.due'); ?></td>
                                <td>
                                    <?php echo $person->balnce_text; ?>

                                </td>
                            </tr>
                            <tr class="info">
                                <td><?php echo app('translator')->getFromJson('front.date'); ?></td>
                                <td colspan="3"><?php echo e($person->created_at); ?></td>
                            </tr>
                        </table>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="box box-primary">
                                    <div class="box-header">
                                        <h4>كشف الحساب</h4>
                                    </div>
                                    <div class="box-body">
                                        <table class="table table-bordered textceneter">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>البيان</th>
                                                    <th>التاريخ</th>
                                                    <th>دائن</th>
                                                    <th>مدين</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $perTrans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($loop->iteration); ?></td>
                                                        <td><?php echo e($perTrans->note); ?></td>
                                                        <td>
                                                            <?php echo e($perTrans->updated_at ? $perTrans->updated_at->format('Y-m-d h:i A') : ''); ?>

                                                        </td>
                                                        <td><?php echo e($perTrans->value < 0 ? number_format(abs($perTrans->value), 2) : '------'); ?>

                                                        </td>
                                                        <td><?php echo e($perTrans->value > 0 ? number_format($perTrans->value, 2) : '------'); ?>

                                                        </td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>

                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php if(true || $person->remember_review_balance): ?>
                            <hr>
                            <div class="row hidden-print">
                                <div class="col-md-12">
                                    <form id="personForm" action="<?php echo e(route('persons.support', $person)); ?>" method="post">
                                        <?php echo e(csrf_field()); ?>

                                        <div class="box box-primary">
                                            <div class="box-body">
                                                <div class="row">
                                                    <div class="col-md-12">
                                                        <div class="form-group">
                                                            <label><?php echo app('translator')->getFromJson('front.title'); ?></label>
                                                            <textarea class="form-control" name="comment"></textarea>
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <div style="padding-top: 10px;" class="col-md-3">
                                                        <div class="form-group">
                                                            <label>ذكرنى بمراجعة الحساب</label>
                                                            <input name="remember_review_balance"
                                                                <?php if($person->remember_review_balance): ?> checked <?php endif; ?>
                                                                type="checkbox" class="flat-red ">
                                                        </div>
                                                    </div>
                                                    <div class="form-group col-md-3">
                                                        <div class="input-group date">
                                                            <div class="input-group-addon">
                                                                <i class="fa fa-calendar"></i>
                                                            </div>
                                                            <input readonly name="remember_date" type="text"
                                                                value="<?php echo e($person->remember_date ?: ''); ?>" id="datepicker"
                                                                class="form-control">
                                                        </div>
                                                        <!-- /.input group -->
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">
                                                            <input placeholder="<?php echo app('translator')->getFromJson('front.address'); ?>"
                                                                value="<?php echo e($person->address); ?>" name="address"
                                                                type="text" class="form-control">
                                                        </div>
                                                    </div>
                                                    <div class="col-md-3">
                                                        <div class="form-group">

                                                            <select name="region_id" class="form-control selectRegion"
                                                                style="width: 100%;">
                                                                <option value=""><?php echo app('translator')->getFromJson('front.select region'); ?></option>
                                                                <?php $__currentLoopData = \App\Region::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $region): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option
                                                                        <?php echo e($region->id == $person->region_id ? 'selected' : ''); ?>

                                                                        value="<?php echo e($region->id); ?>"><?php echo e($region->name); ?>

                                                                    </option>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="box-footer">
                                                <button type="submit" class="btn btn-primary"><?php echo app('translator')->getFromJson('front.save'); ?></button>
                                            </div>
                                        </div>
                                    </form>
                                    <?php if(count($person->support)): ?>
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th><?php echo app('translator')->getFromJson('front.Employee'); ?></th>
                                                    <th><?php echo app('translator')->getFromJson('front.title'); ?></th>
                                                    <th><?php echo app('translator')->getFromJson('front.Date'); ?></th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                <?php $__currentLoopData = $person->support; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <tr>
                                                        <td><?php echo e($loop->iteration); ?></td>
                                                        <td><?php echo e(optional($item->user)->name); ?></td>
                                                        <td><?php echo e($item->comment); ?></td>
                                                        <td><?php echo e($item->created_at); ?></td>
                                                    </tr>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </tbody>
                                        </table>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endif; ?>
                        <hr />

                        <?php if(auth()->user()->can('getSales OrdersController')): ?>
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <td colspan="12"><?php echo app('translator')->getFromJson('front.invoices'); ?></td>
                                    </tr>
                                    <tr>
                                        <th>#</th>
                                        <th>المستخدم</th>
                                        <th><?php echo app('translator')->getFromJson('front.date'); ?></th>
                                        <th><?php echo app('translator')->getFromJson('front.invoicenumber'); ?></th>
                                        <th><?php echo app('translator')->getFromJson('front.payment'); ?></th>
                                        <th><?php echo app('translator')->getFromJson('front.total'); ?></th>
                                        <th>الخصم</th>
                                        <th><?php echo app('translator')->getFromJson('front.paid'); ?></th>
                                        <th><?php echo app('translator')->getFromJson('front.due'); ?></th>
                                        <th><?php echo app('translator')->getFromJson('front.status'); ?></th>
                                        <th><?php echo app('translator')->getFromJson('front.Withdrawals'); ?></th>
                                        <th class="no-sort"></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                        $totalDiscount = 0;
                                    ?>
                                    <?php $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $totalDiscount += $order->dicount_value;
                                        ?>
                                        <tr>
                                            <td><?php echo e($loop->iteration); ?></td>
                                            <td><?php echo e(optional($order->creator)->name); ?></td>
                                            <td><?php echo e($order->invoice_date); ?></td>
                                            <td><?php echo e($order->invoice_number); ?></td>
                                            <td><?php echo e(trans('app.' . $order->payment_type)); ?></td>
                                            <td><?php echo e($order->total); ?></td>
                                            <td><?php echo e($order->dicount_value); ?></td>
                                            <td><?php echo e($order->paid); ?></td>
                                            <td><?php echo e($order->due); ?></td>
                                            <td>
                                                <?php if($order->status): ?>
                                                    <button href="#" type="button" class="btn btn-sm btn-success"><i
                                                            class="fa  fa-check"></i></button>
                                                <?php else: ?>
                                                    <a href="#" type="button" class="btn btn-sm btn-success"><i
                                                            class="fa fa-times"></i></a>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if($order->is_withdrawable): ?>
                                                    <button type="button" class="btn btn-sm btn-success"><i
                                                            class="fa fa-check"></i></button>
                                                <?php else: ?>
                                                    <button type="button" class="btn btn-sm btn-danger"><i
                                                            class="fa fa-times"></i></button>
                                                <?php endif; ?>
                                            </td>
                                            <td class="actions">
                                                <a data-toggle="modal" data-target="#myModal"
                                                    href="<?php echo e(route('orders.show', $order)); ?>"
                                                    class="btn btn-warning btn-xs">
                                                    <i class="fa fa-eye fa-fw" aria-hidden="true"></i>
                                                </a>
                                                <?php if(auth()->user()->can('edit OrdersController')): ?>
                                                    <a href="<?php echo e(route('orders.edit', $order)); ?>"
                                                        class="btn btn-primary btn-xs">
                                                        <i class="fa fa-pencil fa-fw" aria-hidden="true"></i>
                                                    </a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                                <tfoot>
                                    <tr class="bg-danger">
                                        <td colspan="5">الإجمالى</td>
                                        <td><?php echo e($orders->sum('total')); ?></td>
                                        <td><?php echo e($totalDiscount); ?></td>
                                        <td><?php echo e($orders->sum('paid')); ?></td>
                                        <td colspan="4"><?php echo e($orders->sum('due')); ?></td>
                                    </tr>
                                </tfoot>
                            </table>

                            <?php
                                $totalPayment = 0;
                                $personTrans = $transactions
                                    ->where('value', '<', 0)
                                    ->where('note', '<>', 'فرق متبقى الفاتورة')
                                    ->where('note', '<>', 'رصيد أول المدة')
                                    ->where('note', '<>', ' خصم قيمة مرتجعات من الحساب ');
                            ?>
                            <?php if(count($personTrans)): ?>
                                <hr>
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <td colspan="7">
                                                التحصيلات
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>#</th>
                                            <th>المستخدم</th>
                                            <th>المندوب</th>
                                            <th><?php echo app('translator')->getFromJson('front.date'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('front.value'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('front.title'); ?></th>
                                            <th class="no-sort"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $personTrans; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $absValue = abs($trans->value);
                                                $totalPayment += $absValue;
                                            ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e(optional($trans->creator)->name); ?></td>
                                                <td><?php echo e(optional($trans->sale)->name); ?></td>
                                                <td><?php echo e($trans->getOriginal('created_at') ? $trans->created_at->format('Y-m-d h:i A') : $trans->updated_at); ?>

                                                </td>
                                                <td><?php echo e($absValue); ?></td>
                                                <td><?php echo e($trans->note); ?></td>
                                                <td>
                                                    <a class="btn btn-xs btn-danger remove-record"
                                                        data-url="<?php echo e(route('transaction.destroy', $trans->id)); ?>"
                                                        data-id="<?php echo e($trans->id); ?>">
                                                        <i class="fa fa-trash"></i>
                                                        <?php echo app('translator')->getFromJson('front.delete'); ?>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-primary">
                                            <td>الإجمالى</td>
                                            <td></td>
                                            <td></td>
                                            <td></td>
                                            <td><?php echo e($totalPayment); ?></td>
                                            <td colspan="2"></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            <?php endif; ?>

                            <?php
                                $personTrans2 = $transactions->where('value', '>', 0)->where('note', '<>', 'فرق متبقى الفاتورة');
                            ?>

                            <?php if($personTrans2): ?>
                                <hr />
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <td colspan="5">المعاملات النقدية</td>
                                        </tr>
                                        <tr>
                                            <th>#</th>
                                            <th><?php echo app('translator')->getFromJson('front.date'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('front.value'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('front.title'); ?></th>
                                            <th class="no-sort"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $personTrans2; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trans): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($trans->getOriginal('created_at') ? $trans->created_at->format('Y-m-d h:i A') : $trans->updated_at); ?>

                                                </td>
                                                <td><?php echo e(abs($trans->value)); ?></td>
                                                <td><?php echo e($trans->note); ?></td>
                                                <td>
                                                    <a class="btn btn-xs btn-danger remove-record"
                                                        data-url="<?php echo e(route('transaction.destroy', $trans->id)); ?>"
                                                        data-id="<?php echo e($trans->id); ?>">
                                                        <i class="fa fa-trash"></i>
                                                        <?php echo app('translator')->getFromJson('front.delete'); ?>
                                                    </a>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-primary">
                                            <td colspan="2">الاجمالى</td>
                                            <td colspan="3"><?php echo e($personTrans2->sum('value')); ?></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            <?php endif; ?>

                            <?php if(count($sales_returns)): ?>
                                <hr>
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <td colspan="5"><?php echo app('translator')->getFromJson('front.ordersreturns'); ?></td>
                                        </tr>
                                        <tr>
                                            <th>#</th>
                                            <th><?php echo app('translator')->getFromJson('front.date'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('front.value'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('front.payment'); ?></th>
                                            <th class="no-sort"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $sales_returns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $return): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($return->return_date); ?></td>
                                                <td><?php echo e($return->return_value); ?></td>
                                                <td>
                                                    <?php echo e($return->is_cash ? trans('front.cash') : trans('front.from previous balance')); ?>

                                                </td>
                                                <td class="actions">
                                                    <a data-toggle="modal" data-target="#myModal"
                                                        href="<?php echo e(route('returns.show', $return)); ?>"
                                                        class="btn btn-warning btn-xs">
                                                        <i class="fa fa-eye fa-fw" aria-hidden="true"></i>
                                                        <?php echo app('translator')->getFromJson('front.show'); ?>
                                                    </a>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-blue">
                                            <td colspan="2">
                                                الإجمالى
                                            </td>
                                            <td><?php echo e($sales_returns->sum('return_value')); ?></td>
                                            <td></td>
                                            <td></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            <?php endif; ?>

                            <?php if(count($purchase_returns)): ?>
                                <hr>
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <td colspan="5">
                                                <?php echo app('translator')->getFromJson('front.purchasereturns'); ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>#</th>
                                            <th><?php echo app('translator')->getFromJson('front.date'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('front.value'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('front.payment'); ?></th>
                                            <th class="no-sort"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $purchase_returns; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $return): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($return->return_date); ?></td>
                                                <td><?php echo e($return->return_value); ?></td>
                                                <td>
                                                    <?php echo e($return->is_cash ? trans('front.cash') : trans('front.from previous balance')); ?>

                                                </td>
                                                <td class="actions">
                                                    <a data-toggle="modal" data-target="#myModal"
                                                        href="<?php echo e(route('returns.show', $return)); ?>"
                                                        class="btn btn-warning btn-xs">
                                                        <i class="fa fa-eye fa-fw" aria-hidden="true"></i>
                                                        <?php echo app('translator')->getFromJson('front.show'); ?>
                                                    </a>

                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-danger">
                                            <td colspan="2"><?php echo app('translator')->getFromJson('front.total'); ?></td>
                                            <td colspan="3"><?php echo e($purchase_returns->sum('return_value')); ?></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            <?php endif; ?>
                            <?php if(count($person->totalٌReturn)): ?>
                                <?php
                                    $returnproductArr = [];
                                ?>
                                <?php $__currentLoopData = $person->totalٌReturn; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $returnproductArr[$order->product_id] = $order->sum;
                                    ?>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                            <?php if(count($person->totalProduct)): ?>
                                <hr>
                                <table class="table table-bordered table-striped hidden-print">
                                    <thead>
                                        <tr>
                                            <td colspan=3"><?php echo app('translator')->getFromJson('front.orderdetails'); ?></td>
                                        </tr>
                                        <tr>
                                            <th>#</th>
                                            <th><?php echo app('translator')->getFromJson('front.product'); ?></th>
                                            <th><?php echo app('translator')->getFromJson('front.Total sales'); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                            $totalQty = 0;
                                        ?>
                                        <?php $__currentLoopData = $person->totalProduct; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $qty = isset($returnproductArr[$order->product_id]) ? $order->sum - $returnproductArr[$order->product_id] : $order->sum;
                                                $totalQty += $qty;
                                            ?>
                                            <tr>
                                                <td><?php echo e($loop->iteration); ?></td>
                                                <td><?php echo e($order->product->name); ?></td>
                                                <td><?php echo e($qty); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                    <tfoot>
                                        <tr class="bg-red">
                                            <td colspan="2"></td>
                                            <td><?php echo e($totalQty); ?></td>
                                        </tr>
                                    </tfoot>
                                </table>
                            <?php endif; ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('css'); ?>
    <style>
        @media  print {
            <?php if($settings['printerType'] == 'A5'): ?>
                table {
                    max-width: 19cm !important;
                    width: 19cm !important;
                }
            <?php elseif($settings['printerType'] == 'A4'): ?>
                .row,
                .col-md-12,
                table {
                    max-width: 28cm !important;
                    width: 28cm !important;
                }
            <?php endif; ?>
            html,
            body {
                height: 100vh;
                width: 100vh;
                margin: 0px !important;
                padding-right: 5px !important;
                /*overflow: hidden;*/
            }
        }

        .textceneter td,
        .textceneter thead tr th {
            border: 1px solid black !important;
            text-align: center !important;
        }

        thead tr th {
            font-weight: bold !important;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        $('#datepicker').datepicker({
            autoclose: true,
            rtl: true,
            format: 'yyyy-mm-dd',
            language: "<?php echo e(\Session::get('locale')); ?>",

        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>