@extends('layouts.app')
@section('title', 'الحجوزات')
@section('content')
    <section class="content">
        <div class="row">
            <div class="col-md-6">
                <div class="box box-solid">
                    <div class="box-header with-border">
                        <h3 class="box-title">اضافة حجز جديد</h3>
                    </div>
                    <div class="box-body">
                        <form action="{{ route('orders.store') }}" method="post">
                            {{ csrf_field() }}
                            <input type="hidden" name="ispos" value="1">
                            <input type="hidden" value="bookings" name="order[invoice_type]">


                            <div class="hide">
                                <div class="form-group">
                                    <label>@lang('front.status')</label>
                                    <select data-placeholder="@lang('front.select')" name="order[status]"
                                        class="form-control select2 " style="width:100%;">
                                        <option selected value="delivered">@lang('front.delivered')</option>
                                        <option value="not-delivered">@lang('front.not-delivered')</option>
                                    </select>
                                </div>
                            </div>
                            <input id="savePrint" name="savePrint" value="" type="hidden">
                            <div class="row">

                                <div class="col-md-12">
                                    <div class="box box-primary">
                                        <div class="box-body">
                                            <div class="col-md-6 hide">
                                                <div class="form-group">
                                                    <label for="">@lang('front.store')</label>
                                                    <select id="productStores" class="form-control storeList"
                                                        required="required">
                                                        @foreach (auth()->user()->stores as $s)
                                                            <option value="{{ $s->id }}">{{ $s->name }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>

                                            <div class="col-md-6 hide">
                                                <div class="form-group">
                                                    <label>@lang('front.payment')</label>
                                                    <select id="paymentMethod" data-placeholder="@lang('front.select')"
                                                        name="order[payment_type]" class="form-control select2 "
                                                        style="width:100%;">
                                                        <option value="cash">
                                                            @lang('front.cash')
                                                        </option>
                                                        <option selected value="delayed">
                                                            @lang('front.Postpaid')</option>
                                                        <option value="visa">@lang('front.visa')</option>
                                                        <option
                                                            {{ $settings['default_payment'] == 'link transfer' ? 'selected' : '' }}
                                                            value="link transfer">
                                                            @lang('front.link transfer')</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    @php
                                                        $title = trans('front.client');
                                                        $defaultperson = \App\Person::whereIn('name', [
                                                            'عميل نقدي',
                                                            'عميل كاش',
                                                        ])->first();
                                                        $salesMan = \App\Employee::where('type', 'sales')->get();
                                                        $marktersMan = \App\Employee::where('type', 'markter')->get();
                                                        $userListRoute = route('person.getList', ['type' => 'client']);
                                                        $route = route('client.create', ['req' => 'ajax']);
                                                    @endphp
                                                    <label>
                                                        @lang('front.client') <span class="lastBalance"
                                                            style="color: red"></span>
                                                    </label>
                                                    <div class="input-group">
                                                        <select data-ajax--url="{{ $userListRoute }}"
                                                            data-ajax--cache="true" data-placeholder="@lang('front.select')"
                                                            id="personList" name="order[client_id]" required
                                                            class="form-control select2">
                                                            <option data-mobile="" value="">@lang('front.select')
                                                            </option>
                                                            @if (isset(old('order')['client_id']) && !empty(old('order')['client_id']))
                                                                @php
                                                                    $per = \App\Person::find(old('order')['client_id']);
                                                                @endphp
                                                                <option points="{{ $per->total_points }}"
                                                                    data-mobile="{{ $per->mobile . ' ' . $per->mobile2 }}"
                                                                    last_transaction="{{ $per->last_transaction }}"
                                                                    priceType="{{ $per->priceType }}"
                                                                    rel="{{ $per->total_due }}" selected
                                                                    value="{{ $per->id }}">{{ $per->name }}
                                                                </option>
                                                            @else
                                                                @if ($defaultperson)
                                                                    <option points="{{ $defaultperson->total_points }}"
                                                                        data-mobile="{{ $defaultperson->mobile . ' ' . $defaultperson->mobile2 }}"
                                                                        last_transaction="{{ $defaultperson->last_transaction }}"
                                                                        priceType="{{ $defaultperson->priceType }}"
                                                                        rel="{{ $defaultperson->total_due }}" selected
                                                                        value="{{ $defaultperson->id }}">
                                                                        {{ $defaultperson->name }}
                                                                    </option>
                                                                @endif
                                                            @endif
                                                        </select>
                                                        <div class="input-group-addon no-print" style="padding: 2px 5px;">
                                                            <a href="{{ $route }}" class="external"
                                                                data-toggle="modal" data-target="#addPersonModal">
                                                                <i class="fa fa-2x fa-plus-circle"></i>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="box box-success">
                                            <div class="box-body">
                                                <div class="nav-tabs-vertical">
                                                    <div class="row">
                                                        <div class="col-md-4">
                                                            <ul class="nav nav-tabs">
                                                                <li class="header"><i class="fa fa-th"></i>
                                                                    @lang('front.categories')</li>
                                                                @foreach ($categories as $category)
                                                                    <li
                                                                        @if ($loop->iteration == 1) class="active" @endif>
                                                                        <a href="#tab-{{ $category->id }}"
                                                                            data-toggle="tab">{{ $category->name }}</a>
                                                                    </li>
                                                                @endforeach

                                                            </ul>
                                                        </div>
                                                        <div class="col-md-8">
                                                            <div class="tab-content">

                                                                @foreach ($categories as $category)
                                                                    <div style="padding: 10px"
                                                                        class="tab-pane {{ $loop->iteration == 1 ? 'active' : '' }}"
                                                                        id="tab-{{ $category->id }}">
                                                                        @foreach ($category->productsservices->chunk(6) as $chunks)
                                                                            <div class="row">
                                                                                @foreach ($chunks as $item)
                                                                                    @include(
                                                                                        'orders.item_card',
                                                                                        ['col' => 4]
                                                                                    )
                                                                                @endforeach
                                                                            </div>
                                                                        @endforeach

                                                                        @foreach ($category->productsservicesSubCategory->chunk(6) as $chunks)
                                                                            <div class="row">
                                                                                @foreach ($chunks as $item)
                                                                                    @include(
                                                                                        'orders.item_card',
                                                                                        ['col' => 2]
                                                                                    )
                                                                                @endforeach
                                                                            </div>
                                                                        @endforeach

                                                                    </div>
                                                                @endforeach
                                                                <!-- /.tab-pane -->
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <!-- /.tab-content -->
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-md-12">
                                        <div class="box box-warning">
                                            <div class="box-body">
                                                <table class="table table-bordered table-responsive">
                                                    <thead>
                                                        <tr>
                                                            <th>#</th>
                                                            <th>الخدمة</th>
                                                            <th class="hide">الكمية</th>
                                                            <th class="hide">الوحدة</th>
                                                            <th>السعر</th>
                                                            <th class="hide">الاجمالي</th>
                                                            <th>ملحوظة</th>
                                                            <th>الموظف</th>
                                                            <th>التاريخ/الوقت</th>
                                                            <th></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="invoiceTable">
                                                    </tbody>
                                                </table>

                                            </div>
                                            <div class="box-footer">
                                                <button type="submit" class="btn btn-primary "><i
                                                        class="fa fa-save"></i>
                                                    @lang('front.save') </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-12 hide">
                                    <div class="box box-primary">
                                        <div class="box-body">
                                            <table class="table table-bordered pull-right">
                                                <tr>
                                                    <td>
                                                        <label>
                                                            @lang('front.total'):-
                                                        </label>
                                                        <input readonly id="total" value="" value="0"
                                                            class="form-control">
                                                    </td>
                                                    <td>
                                                        <label>
                                                            @lang('front.discount'):-
                                                        </label>
                                                        <div class="input-group">
                                                            <input type="number" step="0.01" required id="discount"
                                                                name="order[discount]" value="0"
                                                                class="form-control">
                                                            <input type="hidden" name="order[discount_value]"
                                                                value="0">

                                                            <span class="input-group-addon ">
                                                                <input id="discount_type" value="1"
                                                                    name="order[discount_type]" type="checkbox"
                                                                    class="flat-red ">
                                                                %
                                                            </span>
                                                            <span style="color:#ffffff;" id="disValue"
                                                                class="input-group-addon btn ">

                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <label>
                                                            @lang('front.tax'):-
                                                        </label>
                                                        <input id="TaxValue" name="order[tax_value]" value="0"
                                                            class="hide">
                                                        <div class="input-group">
                                                            <input id="tax" name="order[tax]"
                                                                value="{{ $settings['taxValue'] ?? 0 }}"
                                                                class="form-control">
                                                            <span class="input-group-addon btn">
                                                                %
                                                            </span>
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <label>
                                                            @lang('front.grand'):
                                                        </label>
                                                        <input readonly id="totalafter" value=""
                                                            name="order[total]" value="0" class="form-control">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td>
                                                        <label>
                                                            @lang('front.paid'):-
                                                        </label>
                                                        <input type="number" step="0.01" required id="paid"
                                                            name="order[paid]" value="0" class="form-control" />
                                                    </td>
                                                    <td>
                                                        <label>
                                                            @lang('front.due'):-
                                                        </label>
                                                        <div class="input-group">
                                                            <input readonly required id="due" name="order[due]"
                                                                value="0" class="form-control" />
                                                        </div>
                                                    </td>
                                                    <td>
                                                        <label>
                                                            @lang('front.before'):-
                                                        </label>
                                                        <input readonly required id="lastBalance" value="0"
                                                            class="form-control">
                                                    </td>
                                                    <td>
                                                        <label>
                                                            @lang('front.balance'):-
                                                        </label>
                                                        <input readonly required id="totalBalance" value=""
                                                            class="form-control">
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td colspan="4">
                                                        <button type="submit" class="btn btn-primary "><i
                                                                class="fa fa-save"></i>
                                                            @lang('front.save') </button>
                                                        <button type="submit" class="btn btn-success saveandPrint"><i
                                                                class="fa fa-print"></i> @lang('front.save and print') </button>
                                                    </td>
                                                </tr>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </form>
                    </div>
                </div>
            </div>
            <div class="col-md-6">
                <div class="box box-primary">
                    <div class="box-header with-border">
                        <div class="row" style="margin-top: 10px; margin-right: -5px;">
                            @php
                                $statusList = [
                                    'معلق' => '#FF9800',
                                    'جارى العمل' => '#337ab7',
                                    'مكتمله' => '#008d4c',
                                    'مؤجله' => '#d73925',
                                ];
                            @endphp
                            @foreach ($statusList as $key => $color)
                                <div class="col-md-3">
                                    <i style="color: {{ $color }};" class="fa fa-square fa-2x"></i> <span
                                        class="colortextspan">{{ $key }}</span>
                                </div>
                            @endforeach
                        </div>
                    </div>
                    <div class="box-body no-padding">
                        <div class="row">
                            <div class="col-md-12">
                                <iframe width="100%" height="800px" frameborder="0"
                                    src="{{ route('reservations.schedule') }}"></iframe>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /. box -->
            </div>
            <!-- /.col -->
        </div>
    </section>


@stop


@include('reservations._book_script')
