<?php
namespace App\Http\Controllers;
use App\Employee;
use App\OrderDetail;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ReportController extends Controller
{

    public function employeesReport()
    {
        $startDate = \request('fromdate');
        $endDate = \request('todate');
        $query = OrderDetail::select('employee_id', DB::raw('count(*) as total_orders'), DB::raw('sum(price) as total_amount'))
            ->whereNotNull('employee_id')
           ;

        if ($startDate && $endDate) {
            $query->whereBetween('created_at', [$startDate, $endDate]);
        } elseif ($startDate) {
            $query->where('created_at', '>=', $startDate);
        }elseif ($endDate) {
            $query->where('created_at', '<=', $endDate);
        }
        $totalResults = clone $query;
        $totalResults = $totalResults->first();
        $query->groupBy('employee_id');
        $results = $query->get();

        $results->load('employee');
        return view('reports.employees',compact('results','totalResults'));
    }

    public function categoriesReport()
    {
        $startDate = \request('fromdate');
        $endDate = \request('todate');
        $sql = "
                SELECT
                    categories.name AS category_name,
                    employees.name AS employee_name,
                    COUNT(order_detailes.id) AS total_orders,
                    SUM(order_detailes.price) AS total_amount
                FROM
                    categories
                INNER JOIN
                    products ON categories.id = products.main_category_id
                INNER JOIN
                    order_detailes ON products.id = order_detailes.product_id
                INNER JOIN
                    employees ON order_detailes.employee_id = employees.id
                WHERE 1 = 1
            ";

        $bindings = [];
        if ($startDate) {
            $sql .= " AND order_detailes.created_at >= :startDate";
            $bindings['startDate'] = $startDate;
        }

        if ($endDate) {
            $sql .= " AND order_detailes.created_at <= :endDate";
            $bindings['endDate'] = $endDate;
        }
        $totalResults = DB::select(DB::raw($sql), $bindings);
        $sql .= " GROUP BY categories.name, employees.name";
        $results = DB::select(DB::raw($sql), $bindings);
        return view('reports.categories',compact('results','totalResults'));
    }



}
