<?php $__env->startSection('title',trans('front.products')); ?>
<?php $__env->startSection('content'); ?>
	<!-- Content Header (Page header) -->
	<input type="hidden" id="pageRoute" value="<?php echo e(route('products.index',['is_raw'=>$is_raw])); ?>">
	<section class="content-header">
		<h1>
			<?php if($is_raw): ?>
				قائمة الخامات
			<?php else: ?>
				<?php echo app('translator')->getFromJson('front.productsList'); ?>
			<?php endif; ?>
			<a class="btn btn-success pull-right" href="<?php echo e(route('products.create',['is_raw'=>$is_raw])); ?>" ><i class="fa fa-plus"></i> <?php echo app('translator')->getFromJson('front.Add'); ?></a>
		</h1>
	</section>
	<?php
		$isAdmin = auth()->user()->roles()->first()->id==1;
		if($isAdmin){
			$showcost = true && auth()->user()->show_cost_price;
		}else{
			$showcost = $settings['show_cost_price']==1 && auth()->user()->show_cost_price;
		}

		$showImg = $settings['showImage']==1;
	?>
	<!-- Main content -->
	<section class="content">
		<div style="margin-bottom: 5px;" class="row hideprint">
			<form action="<?php echo e(route('products.index')); ?>">
				<div class="">
                    <div class="col-md-3">
                        <input class="form-control" name="keyword" value="<?php echo e(request('keyword')); ?>" placeholder="كلمة البحث"/>
                    </div>
					<div class="col-md-3">
						<select name="main_category_id" id="category_id" class="form-control select2" style="width: 100% !important;height: 35px !important;">
							<option value=""><?php echo app('translator')->getFromJson('front.parent'); ?></option>
							<?php $__currentLoopData = \App\Category::where('type',1)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option <?php echo e(request('main_category_id')==$cat->id?'selected':''); ?>  value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>
					</div>
					<div class="col-md-3">
						<select id="sub_category_id" name="sub_category_id" class="form-control select2" style="width: 100% !important;height: 35px !important;">
							<option value=""><?php echo app('translator')->getFromJson('front.child'); ?></option>
							<?php $__currentLoopData = \App\Category::where('type',2)->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cat): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<option <?php echo e(request('sub_category_id')==$cat->id?'selected':''); ?>   value="<?php echo e($cat->id); ?>"><?php echo e($cat->name); ?></option>
							<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						</select>
					</div>
					<div class="col-md-3">
						<button type="submit" style="width: 200px; " type="button" class="btn btn-info btn-flat"><?php echo app('translator')->getFromJson('front.search'); ?></button>
					</div>
				</div>
			</form>
		</div>
		<div class="row">
			<div class="col-xs-12">
				<div class="box">
				
				<!-- /.box-header -->
					<div class="box-body">
                        <div  class="bg-yellow" style="padding: 5px;margin: 10px;font-size: 20px;">
                            إجمالي الجرد = <p style="display: inline;" id="sumPriceOne"></p> <?php echo e(currency()->getCurrency()['symbol']??''); ?>

                        </div>
						<table class="table text-center table-striped table-bordered  dataTableList" style="width:100%">
							<thead>
								<tr>
									<th>#</th>
									<?php if($showImg): ?>
									<th><?php echo app('translator')->getFromJson('front.image'); ?></th>
									<?php endif; ?>
									<th><?php echo app('translator')->getFromJson('front.product'); ?></th>
									<th><?php echo app('translator')->getFromJson('front.parent'); ?></th>
									<th><?php echo app('translator')->getFromJson('front.child'); ?></th>
									<?php if($showcost): ?>
									<th> <?php echo app('translator')->getFromJson('front.cost'); ?></th>
									<?php endif; ?>
                                    <?php if(auth()->user()->show_sale_price): ?>
									<th> <?php echo app('translator')->getFromJson('front.price'); ?></th>
                                    <?php endif; ?>
									<th><?php echo app('translator')->getFromJson('front.quantity'); ?></th>
									<th><?php echo app('translator')->getFromJson('front.action'); ?></th>
								</tr>
							</thead>
                            <tbody></tbody>
						</table>
					</div>
					<!-- /.box-body -->
				</div>
				<!-- /.box -->
			</div>
			<!-- /.col -->
		</div>
		<!-- /.row -->
	</section>
	<!-- /.content -->

	<div id="myModal" class="modal fade" style="overflow:hidden;" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-body">
					<p class="text-center"><div class="fa-3x text-center"><i class="fa fa-cog fa-spin"></i>                    <?php echo app('translator')->getFromJson('front.Loading ....'); ?>                </div>                </p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-outline pull-left" data-dismiss="modal">إغلاق</button>
				</div>
			</div>
		</div>
	</div>
	<div id="myModalFullScreen" class="modal fade modal-fullscreen" style="overflow:hidden;" role="dialog" aria-labelledby="myModalLabel">
		<div class="modal-dialog modal-lg">
			<div class="modal-content">
				<div class="modal-body">
					<p class="text-center"><div class="fa-3x text-center"><i class="fa fa-cog fa-spin"></i>                    <?php echo app('translator')->getFromJson('front.Loading ....'); ?>                </div>                </p>
				</div>
				<div class="modal-footer">
					<button type="button" class="btn btn-outline pull-left" data-dismiss="modal">إغلاق</button>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('css'); ?>
	<style>
		.typeahead {
			z-index: 1051;
			direction: rtl;
		}

		.twitter-typeahead {
			width: 100%;
			height: 28px;
		}
		.tt-query {
			-webkit-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
			-moz-box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
			box-shadow: inset 0 1px 1px rgba(0, 0, 0, 0.075);
		}

		.tt-hint {
			color: #999
		}

		.tt-menu {    /* used to be tt-dropdown-menu in older versions */
			width: 100%;
			margin-top: 2px;
			padding: 4px 0;
			background-color: #fff;
			border: 1px solid #ccc;
			border: 1px solid rgba(0, 0, 0, 0.2);
			-webkit-border-radius: 4px;
			-moz-border-radius: 4px;
			border-radius: 4px;
			-webkit-box-shadow: 0 5px 10px rgba(0,0,0,.2);
			-moz-box-shadow: 0 5px 10px rgba(0,0,0,.2);
			box-shadow: 0 5px 10px rgba(0,0,0,.2);
		}

		.tt-suggestion {
			padding: 3px 20px;
			line-height: 24px;
			direction: rtl;
		}

		.tt-suggestion.tt-cursor,.tt-suggestion:hover {
			color: #fff;
			background-color: #0097cf;

		}

		.tt-suggestion p {
			margin: 0;
		}

	</style>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('dataTableJs'); ?>
<script>
    function getData()
    {
        var vars = [], hash;
        var hashes = window.location.href.slice(window.location.href.indexOf('?') + 1).split('&');
        for(var i = 0; i < hashes.length; i++)
        {
            hash = hashes[i].split('=');
            vars.push(hash[0]);
            vars[hash[0]] = hash[1];
        }
        return vars;
    }
    $(".select2").select2();
    var isAdmin = Boolean("<?php echo e($showcost); ?>");
    var showImg = Boolean("<?php echo e($showImg); ?>");
    var main_category_id = getData()['main_category_id'];
    var sub_category_id = getData()['sub_category_id'];
    var keyword = getData()['keyword'];

    var pageUrl = $("#pageRoute").val();
    if(main_category_id!=undefined){
        pageUrl += "&main_category_id="+main_category_id;
    }
    if(sub_category_id!=undefined){
        pageUrl += "&sub_category_id="+sub_category_id;
    }
    if(keyword!=undefined){
        pageUrl += "&keyword="+keyword;
    }
	var columns =  [
        {data: "id", name: "id"}
    ];
    if(showImg){
        columns.push({data:'image',name:'image', orderable: false, searchable: false});
	}
    columns.push({data: "name", name: "name"});
    columns.push({data: "category", name: "category.name"});
    columns.push({data: "subcategory", name: "subcategory.name"});
    if(isAdmin){
        columns.push({data: "cost", name: "cost"});
    }
    <?php if(auth()->user()->show_sale_price): ?>
        columns.push({data: "price", name: "price"});
    <?php endif; ?>
    columns.push({data: "quantity", name: "quantity"});
    columns.push({data: "actions", name: "actions"});
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_except(get_defined_vars(), array('__data', '__path')))->render(); ?>