<header class="main-header">

    <!-- Logo -->
    <a href="<?php echo e(route('home')); ?>" class="logo">
        <!-- mini logo for sidebar mini 50x50 pixels -->
        <span class="logo-mini"><b>S</b>AM</span>
        <!-- logo for regular state and mobile devices -->
        <span class="logo-lg">
            <b><?php echo e(config('developer.appname_'.App::getLocale())); ?></b>
        </span>
    </a>

    <!-- Header Navbar: style can be found in header.less -->
    <nav class="navbar navbar-static-top">
        <!-- Sidebar toggle button-->
        <a href="#" class="sidebar-toggle" data-toggle="offcanvas" role="button">
            <span class="sr-only">Toggle navigation</span>
        </a>
        <?php
            $siteName = app()->getLocale()=='ar'?$settings['SiteName']:$settings['SiteName_en'];
        ?>
        <h4 class="inline" style="color: white; position: relative;top: 14px;"><?php echo e(strip_tags($siteName)); ?></h4>
        <!-- Navbar Right Menu -->
        <div class="navbar-custom-menu">
            <ul class="nav navbar-nav">
                <!-- User Account: style can be found in dropdown.less -->
                <li class="dropdown messages-menu">
                    <a href="<?php echo e(route('changeLang',App::getLocale()=='ar'?'en':'ar')); ?>">
                        <i class="fa fa-globe"></i>
                        <span class="label label-success"><?php echo e(App::getLocale()=='ar'?'EN':'العربية'); ?></span>
                    </a>
                </li>
                <li class="dropdown messages-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        <i class="fa fa-gg"></i>
                        <span class="label label-success"><?php echo e(currency()->getCurrency()['symbol']??''); ?></span>
                    </a>
                    <ul class="dropdown-menu">
                        <li>
                            <ul class="menu">
                                <?php $__currentLoopData = currency()->getActiveCurrencies(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li>
                                        <a href="<?php echo e(request()->fullUrl()); ?><?php echo e(strpos(request()->fullUrl(),'?')?'&currency=':'?currency='); ?><?php echo e($currency['code']); ?>">
                                            <?php echo e($currency['name']); ?>

                                        </a>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </li>
                    </ul>
                </li>
                <?php echo $notifications; ?>

                <li class="dropdown user user-menu">
                    <a href="#" class="dropdown-toggle" data-toggle="dropdown">
                        <img style="margin-left: 5px;" src="<?php echo e(optional(auth()->user()->getFirstMedia('photo'))->getUrl()??asset('defaut.jpg')); ?>" class="user-image" alt="User Image">
                        <span class="hidden-xs"> <?php echo e(auth()->user()->name); ?> </span>
                    </a>
                    <ul class="dropdown-menu">
                        <!-- User image -->
                        <li class="user-header">
                            <img src="<?php echo e(optional(auth()->user()->getFirstMedia('photo'))->getUrl()??asset('defaut.jpg')); ?>" class="img-circle" alt="User Image">

                            <p>
                                <?php echo e(auth()->user()->name); ?>

                                <small><?php echo app('translator')->getFromJson('front.member since'); ?> <?php echo e(auth()->user()->created_at->format('d-m-Y')); ?></small>
                            </p>
                        </li>
                        <!-- Menu Footer-->
                        <li class="user-footer">
                            <div class="pull-left">
                                <?php if(auth()->user()->can('edit UsersController')): ?>
                                    <a data-toggle="modal" data-target="#addPersonModal" href="<?php echo e(route('users.edit', auth()->user()->id)); ?>"
                                    class="btn btn-default btn-flat">
                                        <i class="fa fa-pencil fa-fw" aria-hidden="true"></i>
                                        <span class="hidden-xs"><?php echo app('translator')->getFromJson('front.Profile'); ?></span>
                                    </a>
                                <?php endif; ?>
                            </div>
                            <div class="pull-right">
                                <a class="btn btn-danger btn-flat" title="<?php echo app('translator')->getFromJson('front.signout'); ?>" href="<?php echo e(url('/logout')); ?>"
                                   onclick="event.preventDefault();
                                             document.getElementById('logout-form').submit();">
                                    <i class="fa fa-sign-out" aria-hidden="true"></i>
                                    <?php echo app('translator')->getFromJson('front.signout'); ?>
                                </a>

                                <form id="logout-form" action="<?php echo e(url('/logout')); ?>" method="POST" style="display: none;">
                                    <?php echo e(csrf_field()); ?>

                                </form>
                            </div>
                        </li>
                    </ul>
                </li>
                <!-- Messages: style can be found in dropdown.less-->
                <li class="dropdown messages-menu">
                    <a href="javascript:void(0)" onclick="window.location.reload()">
                        <i class="fa fa-refresh"></i>
                    </a>
                </li>
                <!-- Notifications: style can be found in dropdown.less -->
                <li class="dropdown notifications-menu">
                    <a href="javascript:void(0)" onclick="history.forward()">
                        <i class="fa fa-arrow-right"></i>
                    </a>
                </li>
                <!-- Tasks: style can be found in dropdown.less -->
                <li class="dropdown tasks-menu">
                    <a href="javascript:void(0)" onclick="history.back()">
                        <i class="fa  fa-arrow-left"></i>
                    </a>
                </li>
            </ul>
        </div>

    </nav>
</header>
