<style type="text/css">
    * {
        font-size: <?php echo e($settings['PrintSize']); ?>px !important;
        font-family: 'Times New Roman';
        font-weight: bold;
    }

    .centered {
        text-align: center;
        align-content: center;
    }


    img {
        max-width: inherit;
        width: inherit;
    }

    @media  print {

        .hidden-print,
        .hidden-print * {
            display: none !important;
        }


        .table {
            width: 100% !important;
            text-align: center;
            font-weight: bold;
        }
    }

    .centered {
        text-align: center;
        align-content: center;
    }

    @media  print {
        .table {
            font-size: <?php echo e($settings['PrintSize'] ?? 12); ?>px !important;
        }

        td,
        th,
        tr,
        table {
            border: 1px solid black !important;
            border-collapse: collapse;
        }

        .table {
            border: 1px solid #020202 !important;
        }

        .table td,
        .table th {
            border: 1px solid #020202 !important;
            padding: 1px !important;
        }

        @page  {
            size: 80mm auto;
            margin-top: 5px !important;
        }

        body {

            width: 75mm !important;
            margin: 0.5mm 0 0 0 !important;
            overflow: hidden;
        }

        .service-content {
            page-break-before: always;
        }

        html,
        body {
            /* width: 80mm;
            height: 100%; */
            margin: 0 !important;
            margin-right: 5px !important;
            padding: 0 !important;

        }
    }


</style>

<a class="btn print-window pull-right" href="<?php echo e(route('pos')); ?>" role="button">
    <i class="fa fa-backward" aria-hidden="true"></i> رجوع
</a>
<div class="ticket">
    <div class="service-content">
        <table class="table centered">
            <tr>
                <td colspan="2">

                    <?php if($settings['logo']): ?>
                        <div class="pull-right">
                            <img style="width: 110px" alt="Logo"
                                src="<?php echo e(\Illuminate\Support\Facades\Storage::url($settings['logo'])); ?>

">
                        </div>
                    <?php endif; ?>
                    <div style="margin-bottom: 15px;" class="pull-left">
                        <?php echo $settings['SiteName']; ?>

                        <?php if($settings['Address']): ?>
                            <br />
                            <?php echo $settings['Address']; ?>

                        <?php endif; ?>
                        <?php if($settings['mobile']): ?>
                            <br />
                            <?php echo e($settings['mobile']); ?> <br>
                        <?php endif; ?>

                    </div>
                </td>
            </tr>
        </table>

    <table style="margin-top: 10px;" class="table table-bordered">
        <tr>
            <td style="font-weight: bold;font-size:18px!important;" colspan="2">فاتورة ضريبية مبسطة</td>
        </tr>
        <tr>
            <td>الفاتورة #</td>
            <td><?php echo e($order->invoice_number); ?></td>
        </tr>
        <tr>
            <td>الدفع</td>
            <td><?php echo e($order->payment_type == 'delayed' ? 'أجل' : 'كاش'); ?></td>
        </tr>
        <tr>
            <td>التاريخ</td>
            <td><?php echo e($order->invoice_date); ?></td>
        </tr>
        <tr>
            <td>الكاشير</td>
            <td><?php echo e(auth()->user()->name); ?></td>
        </tr>
        <tr>
            <td>العميل</td>
            <td><?php echo e($order->client->name); ?></td>
        </tr>
    </table>
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th class="description">الوصف</th>
                    <th class="price">السعر</th>
                    <th class="price">إجمالى</th>
                    <th>الموظف</th>
                </tr>
            </thead>
            <tbody>
                <?php
                    $numqty = 0;
                    $sumprice = 0;
                ?>
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <?php
                            $numqty += $item->qty;
                            $sumprice += $item->total;
                            $tqty = $item->qty;
                            $product = optional($item->product);
                        ?>
                        <td class="description">
                            <?php echo e($product->full_name); ?><br />
                            <?php echo e($item->comment); ?>

                        </td>
                        <td class="price">
                            <?php echo e(currency($item->price, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                        </td>
                        <td>
                            <?php echo e(currency($item->total, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                        </td>
                        <td><?php echo e(optional($item->employee)->name); ?></td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>
            <tfoot>
                <tr>
                    <td>عدد الخدمات <?php echo e($numqty); ?></td>
                    <td>الإجمالى</td>
                    <td colspan="2">
                        <?php echo e(currency($sumprice, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <table class="table">
                            <tr>
                                <td>الاجمالي قبل الضريبة</td>
                                <td><?php echo e(currency($order->total - $order->tax_value, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                </td>
                            </tr>
                            <tr>
                                <td>الضريبة</td>
                                <td><?php echo e($order->tax); ?>%</td>
                            </tr>
                            <tr>
                                <td>الخصم</td>
                                <td>
                                    <?php
                                        $discount = 0;
                                        $dist = $order->discount ?: 0;
                                        if ($order->discount) {
                                            if ($order->discount_type == 2) {
                                                $discount = $order->total * ($order->discount / 100);
                                                $dist = $discount;
                                                //$dist = "%".$order->discount. " ( $discount )";
                                            }
                                        }
                                        $totalafterDisc = $order->total - $dist;
                                    ?>
                                    <?php echo e(currency($dist, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                </td>
                            </tr>
                        </table>
                    </td>
                    <td colspan="2">
                        <table class="table">
                            <tr>
                                <td>المجموع</td>
                            </tr>
                            <tr>
                                <td>
                                    <?php echo e(currency($totalafterDisc, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
                <tr>
                    <td colspan="4">إجمالى المستحقات</td>
                </tr>
                <tr>
                    <td colspan="4">
                        <?php echo e(currency($totalafterDisc, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                    </td>
                </tr>
                <?php if($order->client->total_due || $order->due): ?>
                    <tr>
                        <td colspan="4">
                            <table class="table">
                                <tr>
                                    <td colspan="2">كشف حساب مختصر</td>
                                </tr>
                                <tr>
                                    <td>المديونية السابقة</td>
                                    <td>
                                        <?php
                                            $total_due = $order->client->total_due;
                                        ?>
                                        <?php if($total_due): ?>
                                            <?php echo e(currency($total_due - $order->due, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                        <?php else: ?>
                                            0
                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <tr>
                                    <td>الرصيد</td>
                                    <td><?php echo e(currency($total_due, $order->currency, currency()->getUserCurrency(), $format = true)); ?>

                                    </td>
                                </tr>
                <?php endif; ?>
        </table>
        </td>
        </tr>
        <tr>
            <td colspan="4">
                <p>
                    <?php echo $settings['InvoiceNotes']; ?>

                </p>
            </td>
        </tr>
        <tr>
            <td colspan="4">
                <?php
                    $check = true;
                    try {
                        $Qcode = $order->generatQrcode(
                            $settings['SiteName'],
                            $settings['taxNumber'],
                            $order->order_date,
                            $order->total,
                            $order->tax_value,
                        );
                    } catch (\Exception $e) {
                        $check = false;
                    }
                ?>
                <?php if($check): ?>
                    <div style="margin-bottom: 5px;">
                        <img style="width: 100px;" src="<?php echo e($Qcode); ?>">
                    </div>
                <?php endif; ?>
            </td>
        </tr>
        </tfoot>
        </table>
    </div>
    <?php $__currentLoopData = $order->items->groupBy('employee_id'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $employeeitems): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <table class="table service-content">
            <tr>
                <td colspan="2">

                    <?php if($settings['logo']): ?>
                        <div class="pull-right">
                            <img style="width: 110px" alt="Logo"
                                src="<?php echo e(\Illuminate\Support\Facades\Storage::url($settings['logo'])); ?>

    ">
                        </div>
                    <?php endif; ?>
                    <div style="margin-bottom: 15px;" class="pull-left">
                        <?php echo $settings['SiteName']; ?>

                        <?php if($settings['Address']): ?>
                            <br />
                            <?php echo $settings['Address']; ?>

                        <?php endif; ?>
                        <?php if($settings['mobile']): ?>
                            <br />
                            <?php echo e($settings['mobile']); ?> <br>
                        <?php endif; ?>

                    </div>
                </td>
            </tr>
            <tr>
                <td>الفاتورة #</td>
                <td><?php echo e($order->invoice_number); ?></td>
            </tr>
            <tr>
                <td>العميل</td>
                <td><?php echo e($order->client->name); ?></td>
            </tr>
            <tr>
                <td>الموظف</td>
                <td><?php echo e(optional($item->employee)->name); ?></td>
            </tr>
            <?php $__currentLoopData = $employeeitems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td>الخدمة <?php echo e($loop->iteration); ?></td>
                    <td>
                        <?php
                            $serv = optional($item->product)->name;
                            $serv .= ' - '.date('Y-m-d h:i A', strtotime($item->serive_datetime));
                        ?>
                        <p><?php echo e($serv); ?></p>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        </table>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</div>
